/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorSource;
import errorlist.ErrorSourceUpdate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.Position;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;

public class DefaultErrorSource
extends ErrorSource
implements EBComponent {
    protected String name;
    protected int errorCount;
    protected Hashtable errors = new Hashtable();
    private boolean addedToBus;

    public DefaultErrorSource(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public ErrorSource.Error[] getAllErrors() {
        if (this.errors.size() == 0) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        Enumeration enumeration = this.errors.elements();
        while (enumeration.hasMoreElements()) {
            ArrayList arrayList = (ArrayList)enumeration.nextElement();
            for (int i = 0; i < arrayList.size(); ++i) {
                linkedList.add(arrayList.get(i));
            }
        }
        return linkedList.toArray(new ErrorSource.Error[linkedList.size()]);
    }

    public int getFileErrorCount(String string) {
        ArrayList arrayList = (ArrayList)this.errors.get(string);
        if (arrayList == null) {
            return 0;
        }
        return arrayList.size();
    }

    public ErrorSource.Error[] getFileErrors(String string) {
        ArrayList arrayList = (ArrayList)this.errors.get(string);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new ErrorSource.Error[arrayList.size()]);
    }

    public ErrorSource.Error[] getLineErrors(String string, int n, int n2) {
        if (this.errors.size() == 0) {
            return null;
        }
        List list = (List)this.errors.get(string);
        if (list == null) {
            return null;
        }
        LinkedList<DefaultError> linkedList = new LinkedList<DefaultError>();
        int n3 = this.findError(list, n);
        if (n3 != list.size()) {
            DefaultError defaultError;
            int n4 = n3;
            while (n4 >= 0 && ((ErrorSource.Error)list.get(n4)).getLineNumber() >= n) {
                n3 = n4--;
            }
            for (n4 = n3; n4 < list.size() && (defaultError = (DefaultError)list.get(n4)).getLineNumber() <= n2; ++n4) {
                linkedList.add(defaultError);
            }
        }
        if (linkedList.size() == 0) {
            return null;
        }
        return linkedList.toArray(new ErrorSource.Error[linkedList.size()]);
    }

    public synchronized void clear() {
        if (this.errorCount == 0) {
            return;
        }
        this.errors.clear();
        this.errorCount = 0;
        this.removeOrAddToBus();
        if (this.registered) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ErrorSourceUpdate errorSourceUpdate = new ErrorSourceUpdate(DefaultErrorSource.this, ErrorSourceUpdate.ERRORS_CLEARED, null);
                    EditBus.send((EBMessage)errorSourceUpdate);
                }
            });
        }
    }

    public synchronized void removeFileErrors(String string) {
        final ArrayList arrayList = (ArrayList)this.errors.remove(string);
        if (arrayList == null) {
            return;
        }
        this.errorCount -= arrayList.size();
        this.removeOrAddToBus();
        if (this.registered) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        DefaultError defaultError = (DefaultError)arrayList.get(i);
                        ErrorSourceUpdate errorSourceUpdate = new ErrorSourceUpdate(DefaultErrorSource.this, ErrorSourceUpdate.ERROR_REMOVED, defaultError);
                        EditBus.send((EBMessage)errorSourceUpdate);
                    }
                }
            });
        }
    }

    public synchronized void addError(final DefaultError defaultError) {
        ArrayList<DefaultError> arrayList = (ArrayList<DefaultError>)this.errors.get(defaultError.getFilePath());
        if (arrayList == null) {
            arrayList = new ArrayList<DefaultError>();
            this.errors.put(defaultError.getFilePath(), arrayList);
        }
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            ErrorSource.Error error = (ErrorSource.Error)arrayList.get(i);
            if (error.getLineNumber() <= defaultError.getLineNumber()) continue;
            arrayList.add(i, defaultError);
            bl = true;
            break;
        }
        if (!bl) {
            arrayList.add(defaultError);
        }
        ++this.errorCount;
        this.removeOrAddToBus();
        if (this.registered) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ErrorSourceUpdate errorSourceUpdate = new ErrorSourceUpdate(DefaultErrorSource.this, ErrorSourceUpdate.ERROR_ADDED, defaultError);
                    EditBus.send((EBMessage)errorSourceUpdate);
                }
            });
        }
    }

    public void addError(int n, String string, int n2, int n3, int n4, String string2) {
        DefaultError defaultError = new DefaultError(this, n, string, n2, n3, n4, string2);
        this.addError(defaultError);
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof BufferUpdate) {
            this.handleBufferMessage((BufferUpdate)eBMessage);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.name + "]";
    }

    private int findError(List list, int n) {
        int n2 = 0;
        int n3 = list.size() - 1;
        block4: while (true) {
            switch (n3 - n2) {
                case 0: {
                    if (((ErrorSource.Error)list.get(n2)).getLineNumber() >= n) {
                        return n2;
                    }
                    return n2 + 1;
                }
                case 1: {
                    if (((ErrorSource.Error)list.get(n2)).getLineNumber() == n) {
                        return n2;
                    }
                    ++n2;
                    continue block4;
                }
            }
            int n4 = (n3 + n2) / 2;
            int n5 = ((ErrorSource.Error)list.get(n4)).getLineNumber();
            if (n5 == n) {
                return n4;
            }
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
    }

    private void removeOrAddToBus() {
        if (this.addedToBus && this.errorCount == 0) {
            this.addedToBus = false;
            EditBus.removeFromBus((EBComponent)this);
        } else if (!this.addedToBus && this.errorCount != 0) {
            this.addedToBus = true;
            EditBus.addToBus((EBComponent)this);
        }
    }

    private synchronized void handleBufferMessage(BufferUpdate bufferUpdate) {
        block4: {
            ArrayList arrayList;
            Buffer buffer;
            block3: {
                buffer = bufferUpdate.getBuffer();
                if (bufferUpdate.getWhat() != BufferUpdate.LOADED) break block3;
                ArrayList arrayList2 = (ArrayList)this.errors.get(buffer.getSymlinkPath());
                if (arrayList2 == null) break block4;
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ((DefaultError)arrayList2.get(i)).openNotify(buffer);
                }
                break block4;
            }
            if (bufferUpdate.getWhat() == BufferUpdate.CLOSED && (arrayList = (ArrayList)this.errors.get(buffer.getSymlinkPath())) != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    ((DefaultError)arrayList.get(i)).closeNotify(buffer);
                }
            }
        }
    }

    public static class DefaultError
    implements ErrorSource.Error {
        DefaultError next;
        private ErrorSource source;
        private int type;
        private String path;
        private String name;
        private Buffer buffer;
        private int lineIndex;
        private int start;
        private int end;
        private Position linePos;
        private Position startPos;
        private Position endPos;
        private String error;
        private List extras;

        public DefaultError(ErrorSource errorSource, int n, String string, int n2, int n3, int n4, String string2) {
            this.source = errorSource;
            this.type = n;
            if (MiscUtilities.isURL((String)string)) {
                this.path = string;
            } else {
                this.path = MiscUtilities.constructPath((String)System.getProperty("user.dir"), (String)string);
                this.path = MiscUtilities.resolveSymlinks((String)this.path);
            }
            this.lineIndex = n2;
            this.start = n3;
            this.end = n4;
            this.error = string2;
            this.name = MiscUtilities.getFileName((String)string);
            Buffer buffer = jEdit.getBuffer((String)this.path);
            if (buffer != null && buffer.isLoaded()) {
                this.openNotify(buffer);
            }
        }

        public ErrorSource getErrorSource() {
            return this.source;
        }

        public int getErrorType() {
            return this.type;
        }

        public Buffer getBuffer() {
            return this.buffer;
        }

        public String getFilePath() {
            return this.path;
        }

        public String getFileName() {
            return this.name;
        }

        public int getLineNumber() {
            if (this.startPos != null) {
                return this.buffer.getLineOfOffset(this.startPos.getOffset());
            }
            return this.lineIndex;
        }

        public int getStartOffset() {
            if (this.startPos != null) {
                return this.startPos.getOffset() - this.buffer.getLineStartOffset(this.getLineNumber());
            }
            return this.start;
        }

        public int getEndOffset() {
            if (this.endPos != null) {
                return this.endPos.getOffset() - this.buffer.getLineStartOffset(this.getLineNumber());
            }
            return this.end;
        }

        public String getErrorMessage() {
            return this.error;
        }

        public void addExtraMessage(String string) {
            if (this.extras == null) {
                this.extras = new ArrayList();
            }
            this.extras.add(string);
        }

        public String[] getExtraMessages() {
            if (this.extras == null) {
                return new String[0];
            }
            return this.extras.toArray(new String[this.extras.size()]);
        }

        public String toString() {
            return this.getFileName() + ":" + (this.getLineNumber() + 1) + ":" + this.getErrorMessage();
        }

        void openNotify(Buffer buffer) {
            this.buffer = buffer;
            int n = Math.min(this.lineIndex, buffer.getLineCount() - 1);
            this.start = Math.min(this.start, buffer.getLineLength(n));
            int n2 = buffer.getLineStartOffset(n);
            this.startPos = buffer.createPosition(n2 + this.start);
            this.endPos = this.end != 0 ? buffer.createPosition(n2 + this.end) : null;
        }

        void closeNotify(Buffer buffer) {
            this.buffer = null;
            this.linePos = null;
            this.startPos = null;
            this.endPos = null;
        }
    }
}

