/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorListPlugin;
import errorlist.ErrorSource;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public class ErrorHighlight
extends TextAreaExtension {
    private JEditTextArea textArea;
    private Segment seg;
    private Point point;

    public ErrorHighlight(JEditTextArea jEditTextArea) {
        this.textArea = jEditTextArea;
        this.seg = new Segment();
        this.point = new Point();
    }

    public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        ErrorSource[] errorSourceArray = ErrorSource.getErrorSources();
        if (errorSourceArray == null) {
            return;
        }
        FontMetrics fontMetrics = this.textArea.getPainter().getFontMetrics();
        for (int i = 0; i < errorSourceArray.length; ++i) {
            ErrorSource.Error[] errorArray = errorSourceArray[i].getLineErrors(this.textArea.getBuffer().getSymlinkPath(), n2, n2);
            if (errorArray == null) continue;
            for (int j = 0; j < errorArray.length; ++j) {
                this.paintError(errorArray[j], graphics2D, n2, n3, n4, n5 + fontMetrics.getAscent());
            }
        }
    }

    public String getToolTipText(int n, int n2) {
        ErrorSource[] errorSourceArray = ErrorSource.getErrorSources();
        if (!this.textArea.getBuffer().isLoaded()) {
            return null;
        }
        int n3 = this.textArea.xyToOffset(n, n2);
        if (n3 == -1) {
            return null;
        }
        int n4 = this.textArea.getLineOfOffset(n3);
        for (int i = 0; i < errorSourceArray.length; ++i) {
            ErrorSource.Error[] errorArray = errorSourceArray[i].getLineErrors(this.textArea.getBuffer().getSymlinkPath(), n4, n4);
            if (errorArray == null) continue;
            int n5 = this.textArea.getLineStartOffset(n4);
            for (int j = 0; j < errorArray.length; ++j) {
                ErrorSource.Error error = errorArray[j];
                int n6 = error.getStartOffset();
                int n7 = error.getEndOffset();
                if ((n3 < n6 + n5 || n3 > n7 + n5) && (n6 != 0 || n7 != 0)) continue;
                return error.getErrorMessage();
            }
        }
        return null;
    }

    private void paintError(ErrorSource.Error error, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = this.textArea.getLineStartOffset(n);
        int n7 = error.getStartOffset();
        int n8 = error.getEndOffset();
        if (n7 == 0 && n8 == 0) {
            this.textArea.getLineText(n, this.seg);
            for (n5 = 0; n5 < this.seg.count && Character.isWhitespace(this.seg.array[this.seg.offset + n5]); ++n5) {
                ++n7;
            }
            n8 = this.seg.count;
        }
        if (n7 + n6 >= n3 || n8 + n6 <= n2) {
            return;
        }
        n5 = n7 + n6 >= n2 ? this.textArea.offsetToXY((int)n, (int)n7, (Point)this.point).x : 0;
        int n9 = n8 + n6 >= n3 ? this.textArea.offsetToXY((int)n, (int)(n3 - n6 - 1), (Point)this.point).x : this.textArea.offsetToXY((int)n, (int)n8, (Point)this.point).x;
        graphics2D.setColor(ErrorListPlugin.getErrorColor(error.getErrorType()));
        graphics2D.drawLine(n5, n4 + 1, n9, n4 + 1);
    }
}

