/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorSource;
import errorlist.ErrorSourceUpdate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.Selection;

public class ErrorList
extends JPanel
implements EBComponent,
DefaultFocusComponent {
    public static final ImageIcon ERROR_ICON = new ImageIcon((class$errorlist$ErrorList == null ? (class$errorlist$ErrorList = ErrorList.class$("errorlist.ErrorList")) : class$errorlist$ErrorList).getResource("error.png"));
    public static final ImageIcon WARNING_ICON = new ImageIcon((class$errorlist$ErrorList == null ? (class$errorlist$ErrorList = ErrorList.class$("errorlist.ErrorList")) : class$errorlist$ErrorList).getResource("warning.png"));
    private View view;
    private JLabel status;
    private DefaultMutableTreeNode errorRoot;
    private DefaultTreeModel errorModel;
    private JTree errorTree;
    static /* synthetic */ Class class$errorlist$ErrorList;

    public ErrorList(View view) {
        this.view = view;
        this.setLayout(new BorderLayout());
        Box box = new Box(0);
        this.status = new JLabel();
        box.add(this.status);
        box.add(Box.createGlue());
        RolloverButton rolloverButton = new RolloverButton(GUIUtilities.loadIcon((String)"PreviousFile.png"));
        rolloverButton.setToolTipText(jEdit.getProperty((String)"error-list-previous-error-file.label"));
        rolloverButton.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-previous-error-file"));
        box.add((Component)rolloverButton);
        rolloverButton = new RolloverButton(GUIUtilities.loadIcon((String)"NextFile.png"));
        rolloverButton.setToolTipText(jEdit.getProperty((String)"error-list-next-error-file.label"));
        rolloverButton.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-next-error-file"));
        box.add((Component)rolloverButton);
        rolloverButton = new RolloverButton(GUIUtilities.loadIcon((String)"ArrowL.png"));
        rolloverButton.setToolTipText(jEdit.getProperty((String)"error-list-previous-error.label"));
        rolloverButton.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-previous-error"));
        box.add((Component)rolloverButton);
        rolloverButton = new RolloverButton(GUIUtilities.loadIcon((String)"ArrowR.png"));
        rolloverButton.setToolTipText(jEdit.getProperty((String)"error-list-next-error.label"));
        rolloverButton.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-next-error"));
        box.add((Component)rolloverButton);
        box.add(Box.createHorizontalStrut(6));
        rolloverButton = new RolloverButton(GUIUtilities.loadIcon((String)"Clear.png"));
        rolloverButton.setToolTipText(jEdit.getProperty((String)"error-list-clear.label"));
        rolloverButton.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-clear"));
        box.add((Component)rolloverButton);
        this.add("North", box);
        this.errorRoot = new DefaultMutableTreeNode(new Root(), true);
        this.errorModel = new DefaultTreeModel(this.errorRoot, true);
        this.errorTree = new JTree(this.errorModel);
        if (!OperatingSystem.isMacOSLF()) {
            this.errorTree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.errorTree.addMouseListener(new MouseHandler());
        this.errorTree.setCellRenderer(new ErrorCellRenderer());
        this.errorTree.setRootVisible(false);
        this.errorTree.setShowsRootHandles(true);
        ErrorSource[] errorSourceArray = ErrorSource.getErrorSources();
        for (int i = 0; i < errorSourceArray.length; ++i) {
            ErrorSource errorSource = errorSourceArray[i];
            this.addErrorSource(errorSource);
        }
        Object[] objectArray = new TreeNode[]{this.errorRoot, null};
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            objectArray[1] = this.errorRoot.getChildAt(i);
            this.errorTree.expandPath(new TreePath(objectArray));
        }
        JScrollPane jScrollPane = new JScrollPane(this.errorTree);
        jScrollPane.setPreferredSize(new Dimension(640, 200));
        this.add("Center", jScrollPane);
        this.updateStatus();
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((EBComponent)this);
    }

    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus((EBComponent)this);
    }

    public void focusOnDefaultComponent() {
        this.errorTree.requestFocus();
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof ErrorSourceUpdate) {
            this.handleErrorSourceMessage((ErrorSourceUpdate)eBMessage);
        }
    }

    public void nextErrorFile() {
        Serializable serializable;
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this.errorRoot.getChildCount() == 0) {
            this.getToolkit().beep();
            return;
        }
        TreePath treePath = this.errorTree.getSelectionPath();
        if (treePath == null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.errorRoot.getChildAt(0);
        } else {
            serializable = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (serializable.getUserObject() instanceof Extra) {
                serializable = (DefaultMutableTreeNode)serializable.getParent();
            }
            if (serializable.getUserObject() instanceof ErrorSource.Error) {
                serializable = (DefaultMutableTreeNode)serializable.getParent();
            }
            if (serializable.getUserObject() instanceof String) {
                int n = this.errorRoot.getIndex((TreeNode)((Object)serializable));
                if (n == this.errorRoot.getChildCount() - 1) {
                    this.getToolkit().beep();
                    return;
                }
                defaultMutableTreeNode = (DefaultMutableTreeNode)this.errorRoot.getChildAt(n + 1);
            } else {
                return;
            }
        }
        serializable = new TreePath(new TreeNode[]{this.errorRoot, defaultMutableTreeNode});
        this.errorTree.setSelectionPath((TreePath)serializable);
        this.errorTree.scrollPathToVisible((TreePath)serializable);
        jEdit.openFile((View)this.view, (String)((String)defaultMutableTreeNode.getUserObject()));
    }

    public void prevErrorFile() {
        Serializable serializable;
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this.errorRoot.getChildCount() == 0) {
            this.getToolkit().beep();
            return;
        }
        TreePath treePath = this.errorTree.getSelectionPath();
        if (treePath == null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.errorRoot.getChildAt(this.errorRoot.getChildCount() - 1);
        } else {
            serializable = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (serializable.getUserObject() instanceof Extra) {
                serializable = (DefaultMutableTreeNode)serializable.getParent();
            }
            if (serializable.getUserObject() instanceof ErrorSource.Error) {
                serializable = (DefaultMutableTreeNode)serializable.getParent();
            }
            if (serializable.getUserObject() instanceof String) {
                int n = this.errorRoot.getIndex((TreeNode)((Object)serializable));
                if (n == 0) {
                    this.getToolkit().beep();
                    return;
                }
                defaultMutableTreeNode = (DefaultMutableTreeNode)this.errorRoot.getChildAt(n - 1);
            } else {
                return;
            }
        }
        serializable = new TreePath(new TreeNode[]{this.errorRoot, defaultMutableTreeNode});
        this.errorTree.setSelectionPath((TreePath)serializable);
        this.errorTree.scrollPathToVisible((TreePath)serializable);
        jEdit.openFile((View)this.view, (String)((String)defaultMutableTreeNode.getUserObject()));
    }

    public void nextError() {
        Serializable serializable;
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        if (this.errorRoot.getChildCount() == 0) {
            this.getToolkit().beep();
            return;
        }
        TreePath treePath = this.errorTree.getSelectionPath();
        if (treePath == null) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.errorRoot.getChildAt(0);
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0);
        } else {
            serializable = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (serializable.getUserObject() instanceof Extra) {
                serializable = (DefaultMutableTreeNode)serializable.getParent();
            }
            if (serializable.getUserObject() instanceof String) {
                defaultMutableTreeNode2 = serializable;
                defaultMutableTreeNode = (DefaultMutableTreeNode)serializable.getChildAt(0);
            } else if (serializable.getUserObject() instanceof ErrorSource.Error) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)serializable.getParent();
                int n = defaultMutableTreeNode2.getIndex((TreeNode)((Object)serializable));
                if (n == defaultMutableTreeNode2.getChildCount() - 1) {
                    n = this.errorRoot.getIndex(defaultMutableTreeNode2);
                    if (n == this.errorRoot.getChildCount() - 1) {
                        this.getToolkit().beep();
                        return;
                    }
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.errorRoot.getChildAt(n + 1);
                    defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0);
                } else {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n + 1);
                }
            } else {
                return;
            }
        }
        serializable = new TreePath(new TreeNode[]{this.errorRoot, defaultMutableTreeNode2, defaultMutableTreeNode});
        this.selectPath((TreePath)serializable);
        this.openError((ErrorSource.Error)defaultMutableTreeNode.getUserObject());
    }

    public void previousError() {
        Serializable serializable;
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        if (this.errorRoot.getChildCount() == 0) {
            this.getToolkit().beep();
            return;
        }
        TreePath treePath = this.errorTree.getSelectionPath();
        if (treePath == null) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.errorRoot.getChildAt(this.errorRoot.getChildCount() - 1);
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(defaultMutableTreeNode2.getChildCount() - 1);
        } else {
            serializable = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (serializable.getUserObject() instanceof Extra) {
                serializable = (DefaultMutableTreeNode)serializable.getParent();
            }
            if (serializable.getUserObject() instanceof String) {
                int n = this.errorRoot.getIndex((TreeNode)((Object)serializable));
                if (n == 0) {
                    this.getToolkit().beep();
                    return;
                }
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.errorRoot.getChildAt(n - 1);
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(defaultMutableTreeNode2.getChildCount() - 1);
            } else if (serializable.getUserObject() instanceof ErrorSource.Error) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)serializable.getParent();
                int n = defaultMutableTreeNode2.getIndex((TreeNode)((Object)serializable));
                if (n == 0) {
                    n = this.errorRoot.getIndex(defaultMutableTreeNode2);
                    if (n == 0) {
                        this.getToolkit().beep();
                        return;
                    }
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.errorRoot.getChildAt(n - 1);
                    defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(defaultMutableTreeNode2.getChildCount() - 1);
                } else {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n - 1);
                }
            } else {
                return;
            }
        }
        serializable = new TreePath(new TreeNode[]{this.errorRoot, defaultMutableTreeNode2, defaultMutableTreeNode});
        this.selectPath((TreePath)serializable);
        this.openError((ErrorSource.Error)defaultMutableTreeNode.getUserObject());
    }

    private void updateStatus() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            for (int j = 0; j < defaultMutableTreeNode.getChildCount(); ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                ErrorSource.Error error = (ErrorSource.Error)defaultMutableTreeNode2.getUserObject();
                if (error.getErrorType() == 0) {
                    ++n2;
                    continue;
                }
                ++n;
            }
        }
        Object[] objectArray = new Integer[]{new Integer(n2), new Integer(n)};
        this.status.setText(jEdit.getProperty((String)"error-list.status", (Object[])objectArray));
    }

    private void handleErrorSourceMessage(ErrorSourceUpdate errorSourceUpdate) {
        Object object = errorSourceUpdate.getWhat();
        if (object == ErrorSourceUpdate.ERROR_SOURCE_ADDED) {
            this.addErrorSource(errorSourceUpdate.getErrorSource());
            this.updateStatus();
        }
        if (object == ErrorSourceUpdate.ERROR_ADDED) {
            this.addError(errorSourceUpdate.getError(), false);
            this.updateStatus();
        } else if (object == ErrorSourceUpdate.ERROR_REMOVED) {
            this.removeError(errorSourceUpdate.getError());
            this.updateStatus();
        } else if (object == ErrorSourceUpdate.ERRORS_CLEARED || object == ErrorSourceUpdate.ERROR_SOURCE_REMOVED) {
            this.removeErrorSource(errorSourceUpdate.getErrorSource());
            this.updateStatus();
        }
    }

    private void addErrorSource(ErrorSource errorSource) {
        ErrorSource.Error[] errorArray = errorSource.getAllErrors();
        if (errorArray == null) {
            return;
        }
        for (int i = 0; i < errorArray.length; ++i) {
            this.addError(errorArray[i], true);
        }
        this.errorModel.reload(this.errorRoot);
        Object[] objectArray = new TreeNode[]{this.errorRoot, null};
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            objectArray[1] = this.errorRoot.getChildAt(i);
            this.errorTree.expandPath(new TreePath(objectArray));
        }
    }

    private void removeErrorSource(ErrorSource errorSource) {
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            for (int j = 0; j < defaultMutableTreeNode.getChildCount(); ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                if (((ErrorSource.Error)defaultMutableTreeNode2.getUserObject()).getErrorSource() != errorSource) continue;
                defaultMutableTreeNode.remove(defaultMutableTreeNode2);
                if (defaultMutableTreeNode.getChildCount() == 0) {
                    this.errorRoot.remove(defaultMutableTreeNode);
                    --i;
                }
                --j;
            }
        }
        this.errorModel.reload(this.errorRoot);
        Object[] objectArray = new TreeNode[]{this.errorRoot, null};
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            objectArray[1] = this.errorRoot.getChildAt(i);
            this.errorTree.expandPath(new TreePath(objectArray));
        }
    }

    private void addError(ErrorSource.Error error, boolean bl) {
        Object[] objectArray;
        String[] stringArray = error.getExtraMessages();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(error, stringArray.length > 0);
        for (int i = 0; i < stringArray.length; ++i) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new Extra(stringArray[i]), false));
        }
        String string = error.getFilePath();
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            objectArray = (Object[])this.errorRoot.getChildAt(i);
            String string2 = (String)objectArray.getUserObject();
            if (!string2.equals(string)) continue;
            objectArray.add(defaultMutableTreeNode);
            if (!bl) {
                this.errorModel.reload((TreeNode)objectArray);
                this.errorTree.expandPath(new TreePath(new TreeNode[]{this.errorRoot, objectArray, defaultMutableTreeNode}));
            }
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string, true);
        defaultMutableTreeNode2.add(defaultMutableTreeNode);
        this.errorRoot.add(defaultMutableTreeNode2);
        this.errorModel.reload(this.errorRoot);
        if (!bl) {
            objectArray = new TreeNode[]{this.errorRoot, null};
            for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
                objectArray[1] = this.errorRoot.getChildAt(i);
                this.errorTree.expandPath(new TreePath(objectArray));
            }
        }
    }

    private void removeError(ErrorSource.Error error) {
        block0: for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            for (int j = 0; j < defaultMutableTreeNode.getChildCount(); ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                if (defaultMutableTreeNode2.getUserObject() != error) continue;
                defaultMutableTreeNode.remove(defaultMutableTreeNode2);
                if (defaultMutableTreeNode.getChildCount() != 0) continue block0;
                this.errorRoot.remove(defaultMutableTreeNode);
                continue block0;
            }
        }
        this.errorModel.reload(this.errorRoot);
    }

    private void openError(final ErrorSource.Error error) {
        Buffer buffer;
        if (error.getBuffer() != null) {
            buffer = error.getBuffer();
        } else {
            buffer = jEdit.openFile((View)this.view, (String)error.getFilePath());
            if (buffer == null) {
                return;
            }
        }
        VFSManager.runInAWTThread((Runnable)new Runnable(){

            public void run() {
                ErrorList.this.view.goToBuffer(buffer);
                int n = error.getStartOffset();
                int n2 = error.getEndOffset();
                int n3 = error.getLineNumber();
                if (n3 >= 0 && n3 < buffer.getLineCount()) {
                    n += buffer.getLineStartOffset(n3);
                    n2 = n2 == 0 ? buffer.getLineEndOffset(n3) - 1 : (n2 += buffer.getLineStartOffset(n3));
                }
                ErrorList.this.view.getTextArea().setSelection((Selection)new Selection.Range(n, n2));
                ErrorList.this.view.getTextArea().moveCaretPosition(n2);
            }
        });
    }

    private void selectPath(TreePath treePath) {
        this.errorTree.setSelectionPath(treePath);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (defaultMutableTreeNode.getChildCount() > 0) {
            this.errorTree.expandPath(treePath);
            this.errorTree.scrollPathToVisible(treePath.pathByAddingChild(defaultMutableTreeNode.getChildAt(defaultMutableTreeNode.getChildCount() - 1)));
        } else {
            this.errorTree.scrollPathToVisible(treePath);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            TreePath treePath = ErrorList.this.errorTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            if (!ErrorList.this.errorTree.isPathSelected(treePath)) {
                ErrorList.this.errorTree.setSelectionPath(treePath);
            }
            if (!((defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject() instanceof Root)) {
                if (defaultMutableTreeNode.getUserObject() instanceof String) {
                    jEdit.openFile((View)ErrorList.this.view, (String)((String)defaultMutableTreeNode.getUserObject()));
                } else {
                    if (defaultMutableTreeNode.getUserObject() instanceof Extra) {
                        defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    }
                    ErrorList.this.openError((ErrorSource.Error)defaultMutableTreeNode.getUserObject());
                }
            }
        }
    }

    static class ErrorCellRenderer
    extends DefaultTreeCellRenderer {
        private static Font plainFont = UIManager.getFont("Tree.font");
        private static Font boldFont;

        ErrorCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, null, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 == null) {
                this.setIcon(null);
                this.setText(null);
            } else if (object2 instanceof String) {
                this.setFont(boldFont);
                int n2 = 0;
                int n3 = 0;
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                    ErrorSource.Error error = (ErrorSource.Error)defaultMutableTreeNode2.getUserObject();
                    if (error.getErrorType() == 0) {
                        ++n2;
                        continue;
                    }
                    ++n3;
                }
                this.setText(jEdit.getProperty((String)"error-list.file", (Object[])new Object[]{object2, new Integer(n2), new Integer(n3)}));
                this.setIcon(null);
            } else if (object2 instanceof ErrorSource.Error) {
                this.setFont(plainFont);
                ErrorSource.Error error = (ErrorSource.Error)object2;
                this.setText(error.getLineNumber() + 1 + ": " + (error.getErrorMessage() == null ? "" : error.getErrorMessage().replace('\t', ' ')));
                this.setIcon(error.getErrorType() == 1 ? WARNING_ICON : ERROR_ICON);
            } else if (object2 instanceof Extra) {
                this.setFont(plainFont);
                this.setText(object2.toString());
                this.setIcon(null);
            } else if (object2 instanceof Root) {
                this.setText(null);
                this.setIcon(null);
            }
            return this;
        }

        static {
            if (plainFont == null) {
                plainFont = jEdit.getFontProperty((String)"metal.secondary.font");
            }
            boldFont = plainFont.deriveFont(1);
        }
    }

    static class Extra {
        String message;

        Extra(String string) {
            this.message = string;
        }

        public String toString() {
            return this.message;
        }
    }

    static class Root {
        Root() {
        }
    }
}

