/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorHighlight;
import errorlist.ErrorOverview;
import errorlist.ErrorSource;
import errorlist.ErrorSourceUpdate;
import java.awt.Color;
import java.awt.Component;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public class ErrorListPlugin
extends EBPlugin {
    private static boolean showOnError;
    private static boolean showErrorOverview;
    private static Color warningColor;
    private static Color errorColor;
    static /* synthetic */ Class class$errorlist$ErrorOverview;
    static /* synthetic */ Class class$errorlist$ErrorHighlight;

    public void start() {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] editPaneArray = view.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                JEditTextArea jEditTextArea = editPaneArray[i].getTextArea();
                this.initTextArea(jEditTextArea);
                this.addErrorOverviewIfErrors(jEditTextArea);
            }
        }
        this.propertiesChanged();
    }

    public void stop() {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] editPaneArray = view.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                JEditTextArea jEditTextArea = editPaneArray[i].getTextArea();
                this.uninitTextArea(jEditTextArea);
                ErrorListPlugin.removeErrorOverview(jEditTextArea);
            }
        }
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof ErrorSourceUpdate) {
            this.handleErrorSourceMessage((ErrorSourceUpdate)eBMessage);
        } else if (eBMessage instanceof EditPaneUpdate) {
            this.handleEditPaneMessage((EditPaneUpdate)eBMessage);
        } else if (eBMessage instanceof PropertiesChanged) {
            this.propertiesChanged();
        }
    }

    public void showErrorOverviewIfNecessary() {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] editPaneArray = view.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                this.addErrorOverviewIfErrors(editPaneArray[i].getTextArea());
            }
        }
    }

    public static void addErrorOverview(JEditTextArea jEditTextArea) {
        ErrorOverview errorOverview = ErrorListPlugin.getErrorOverview(jEditTextArea);
        if (errorOverview != null) {
            errorOverview.repaint();
        } else {
            errorOverview = new ErrorOverview(jEditTextArea);
            jEditTextArea.addLeftOfScrollBar((Component)errorOverview);
            jEditTextArea.putClientProperty((Object)(class$errorlist$ErrorOverview == null ? (class$errorlist$ErrorOverview = ErrorListPlugin.class$("errorlist.ErrorOverview")) : class$errorlist$ErrorOverview), (Object)errorOverview);
            jEditTextArea.revalidate();
        }
    }

    public static void removeErrorOverview(JEditTextArea jEditTextArea) {
        ErrorOverview errorOverview = ErrorListPlugin.getErrorOverview(jEditTextArea);
        if (errorOverview != null) {
            jEditTextArea.removeLeftOfScrollBar((Component)errorOverview);
            jEditTextArea.revalidate();
            jEditTextArea.putClientProperty((Object)(class$errorlist$ErrorOverview == null ? (class$errorlist$ErrorOverview = ErrorListPlugin.class$("errorlist.ErrorOverview")) : class$errorlist$ErrorOverview), null);
        }
    }

    public static ErrorOverview getErrorOverview(JEditTextArea jEditTextArea) {
        return (ErrorOverview)jEditTextArea.getClientProperty((Object)(class$errorlist$ErrorOverview == null ? (class$errorlist$ErrorOverview = ErrorListPlugin.class$("errorlist.ErrorOverview")) : class$errorlist$ErrorOverview));
    }

    static Color getErrorColor(int n) {
        return n == 1 ? warningColor : errorColor;
    }

    private void propertiesChanged() {
        showOnError = jEdit.getBooleanProperty((String)"error-list.showOnError");
        showErrorOverview = jEdit.getBooleanProperty((String)"error-list.showErrorOverview");
        warningColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"error-list.warningColor"));
        errorColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"error-list.errorColor"));
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] editPaneArray = view.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                JEditTextArea jEditTextArea = editPaneArray[i].getTextArea();
                this.addErrorOverviewIfErrors(jEditTextArea);
            }
        }
    }

    private void initTextArea(JEditTextArea jEditTextArea) {
        ErrorHighlight errorHighlight = new ErrorHighlight(jEditTextArea);
        jEditTextArea.getPainter().addExtension((TextAreaExtension)errorHighlight);
        jEditTextArea.putClientProperty((Object)(class$errorlist$ErrorHighlight == null ? (class$errorlist$ErrorHighlight = ErrorListPlugin.class$("errorlist.ErrorHighlight")) : class$errorlist$ErrorHighlight), (Object)errorHighlight);
    }

    private void uninitTextArea(JEditTextArea jEditTextArea) {
        ErrorHighlight errorHighlight = (ErrorHighlight)((Object)jEditTextArea.getPainter().getClientProperty((Object)(class$errorlist$ErrorHighlight == null ? (class$errorlist$ErrorHighlight = ErrorListPlugin.class$("errorlist.ErrorHighlight")) : class$errorlist$ErrorHighlight)));
        if (errorHighlight != null) {
            jEditTextArea.getPainter().removeExtension((TextAreaExtension)errorHighlight);
            jEditTextArea.putClientProperty((Object)(class$errorlist$ErrorHighlight == null ? (class$errorlist$ErrorHighlight = ErrorListPlugin.class$("errorlist.ErrorHighlight")) : class$errorlist$ErrorHighlight), null);
        }
    }

    private void showErrorList(View view) {
        DockableWindowManager dockableWindowManager = view.getDockableWindowManager();
        dockableWindowManager.addDockableWindow("error-list");
    }

    private void handleErrorSourceMessage(ErrorSourceUpdate errorSourceUpdate) {
        Object object = errorSourceUpdate.getWhat();
        if (object == ErrorSourceUpdate.ERROR_ADDED) {
            ErrorSource.Error error = errorSourceUpdate.getError();
            Buffer buffer = error.getBuffer();
            if (buffer != null) {
                this.invalidateLineInAllViews(buffer, error.getLineNumber());
            }
            if (showOnError && jEdit.getActiveView() != null) {
                this.showErrorList(jEdit.getActiveView());
            }
        } else if (object == ErrorSourceUpdate.ERROR_REMOVED) {
            ErrorSource.Error error = errorSourceUpdate.getError();
            Buffer buffer = error.getBuffer();
            if (buffer != null) {
                this.invalidateLineInAllViews(buffer, error.getLineNumber());
            }
            if (showOnError && jEdit.getActiveView() != null) {
                this.showErrorList(jEdit.getActiveView());
            }
        } else if (object == ErrorSourceUpdate.ERRORS_CLEARED || object == ErrorSourceUpdate.ERROR_SOURCE_ADDED || object == ErrorSourceUpdate.ERROR_SOURCE_REMOVED) {
            for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
                EditPane[] editPaneArray = view.getEditPanes();
                for (int i = 0; i < editPaneArray.length; ++i) {
                    EditPane editPane = editPaneArray[i];
                    editPane.getTextArea().getPainter().repaint();
                    this.addErrorOverviewIfErrors(editPane.getTextArea());
                }
            }
            if (object == ErrorSourceUpdate.ERROR_SOURCE_ADDED && showOnError && jEdit.getActiveView() != null) {
                this.showErrorList(jEdit.getActiveView());
            }
        }
    }

    private void invalidateLineInAllViews(Buffer buffer, int n) {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] editPaneArray = view.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                EditPane editPane = editPaneArray[i];
                if (editPane.getBuffer() != buffer) continue;
                editPane.getTextArea().invalidateLine(n);
                this.addErrorOverviewIfErrors(editPane.getTextArea());
            }
        }
    }

    private void handleEditPaneMessage(EditPaneUpdate editPaneUpdate) {
        JEditTextArea jEditTextArea = editPaneUpdate.getEditPane().getTextArea();
        Object object = editPaneUpdate.getWhat();
        if (object == EditPaneUpdate.CREATED) {
            this.initTextArea(jEditTextArea);
            this.addErrorOverviewIfErrors(jEditTextArea);
        } else if (object == EditPaneUpdate.DESTROYED) {
            this.uninitTextArea(jEditTextArea);
            ErrorListPlugin.removeErrorOverview(jEditTextArea);
        } else if (object == EditPaneUpdate.BUFFER_CHANGED) {
            this.addErrorOverviewIfErrors(jEditTextArea);
        }
    }

    private void addErrorOverviewIfErrors(JEditTextArea jEditTextArea) {
        Buffer buffer = jEditTextArea.getBuffer();
        if (showErrorOverview) {
            ErrorSource[] errorSourceArray = ErrorSource.getErrorSources();
            for (int i = 0; i < errorSourceArray.length; ++i) {
                ErrorSource errorSource = errorSourceArray[i];
                if (errorSource.getFileErrors(buffer.getSymlinkPath()) == null) continue;
                ErrorListPlugin.addErrorOverview(jEditTextArea);
                return;
            }
        }
        ErrorListPlugin.removeErrorOverview(jEditTextArea);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

