/*
 * Decompiled with CFR 0.152.
 */
package editorscheme;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class EditorScheme {
    private Properties properties = new Properties();
    private String filename;
    private boolean readOnly;
    public static final String EXTENSION = ".jedit-scheme";
    private static Vector propertyGroups = new Vector();
    public static final String[] SCHEME_PROPERTY_NAMES;

    public EditorScheme() {
        this.setFilename("");
        this.setReadOnly(true);
    }

    public EditorScheme(String string) {
        this();
        this.setFilename(string);
        this.load();
    }

    public EditorScheme(InputStream inputStream) {
        this();
        this.load(inputStream);
    }

    public void apply() {
        for (int i = 0; i < propertyGroups.size(); ++i) {
            PropertyGroup propertyGroup = (PropertyGroup)propertyGroups.elementAt(i);
            if (!propertyGroup.apply) continue;
            Vector vector = propertyGroup.getPropertyNames();
            for (int j = 0; j < vector.size(); ++j) {
                String string = (String)vector.elementAt(j);
                String string2 = (String)this.properties.get(string);
                jEdit.setProperty((String)string, (String)string2);
            }
        }
        jEdit.propertiesChanged();
        jEdit.saveSettings();
    }

    public void getFromCurrent() {
        for (int i = 0; i < propertyGroups.size(); ++i) {
            PropertyGroup propertyGroup = (PropertyGroup)propertyGroups.elementAt(i);
            Vector vector = propertyGroup.getPropertyNames();
            for (int j = 0; j < vector.size(); ++j) {
                String string = (String)vector.elementAt(j);
                String string2 = jEdit.getProperty((String)string);
                if (string2 == null) continue;
                this.properties.put(string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load() {
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(this.filename);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        this.properties.load(bufferedInputStream);
        Object var4_4 = null;
        if (fileInputStream == null) return;
        try {
            fileInputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                Log.log((int)9, (Object)this, (Object)("loading scheme failed [" + this.filename + "]: " + iOException.toString()));
                Object var4_5 = null;
                if (fileInputStream == null) return;
                try {
                    fileInputStream.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void load(InputStream inputStream) {
        try {
            this.readOnly = true;
            this.properties.load(new BufferedInputStream(inputStream));
        }
        catch (IOException iOException) {
            Log.log((int)9, (Object)this, (Object)("loading scheme from stream failed [" + this.filename + "]: " + iOException.toString()));
        }
    }

    public String toString() {
        return this.getName();
    }

    public void save() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.filename, false);
        this.properties.store(fileOutputStream, "jEdit Editor Scheme\n#:mode=properties:lineSeparator=\\n:");
        fileOutputStream.close();
    }

    public String getName() {
        return (String)this.properties.get("scheme.name");
    }

    public void setName(String string) {
        this.properties.put("scheme.name", string);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public static String getDefaultDir() {
        return MiscUtilities.constructPath((String)jEdit.getSettingsDirectory(), (String)"schemes");
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public String getProperty(String string) {
        return (String)this.properties.get(string);
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public static Vector getPropertyGroups() {
        return propertyGroups;
    }

    static {
        StringTokenizer stringTokenizer = new StringTokenizer(jEdit.getProperty((String)"editor-scheme.property-groups"));
        while (stringTokenizer.hasMoreElements()) {
            String string = stringTokenizer.nextToken();
            propertyGroups.addElement(new PropertyGroup(string));
        }
        SCHEME_PROPERTY_NAMES = new String[]{"scheme.name"};
    }

    public static class PropertyGroup {
        String name;
        String label;
        boolean apply;
        Vector properties = new Vector();

        PropertyGroup(String string) {
            this.name = string;
            this.label = jEdit.getProperty((String)("editor-scheme." + string + ".name"), (String)string);
            this.apply = jEdit.getBooleanProperty((String)("editor-scheme." + string + ".apply"), (boolean)true);
            StringTokenizer stringTokenizer = new StringTokenizer(jEdit.getProperty((String)("editor-scheme." + string + "-props")));
            while (stringTokenizer.hasMoreElements()) {
                this.properties.addElement(stringTokenizer.nextToken());
            }
        }

        public String toString() {
            return this.label;
        }

        public Vector getPropertyNames() {
            return this.properties;
        }

        public void apply(EditorScheme editorScheme) {
            for (int i = 0; i < this.properties.size(); ++i) {
                String string = (String)this.properties.elementAt(i);
                String string2 = editorScheme.getProperty(string);
                if (string2 == null) continue;
                jEdit.setProperty((String)string, (String)string2);
            }
        }
    }
}

