/*
 * Decompiled with CFR 0.152.
 */
package editorscheme;

import editorscheme.EditorScheme;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class EditorSchemePlugin
extends EditPlugin {
    public static final String NAME = "editor-scheme";
    private static Vector packagedSchemes;
    private static Vector schemes;
    private static String userSchemesPath;
    static /* synthetic */ Class class$editorscheme$EditorSchemePlugin;

    public void start() {
        userSchemesPath = MiscUtilities.constructPath((String)jEdit.getSettingsDirectory(), (String)"schemes");
        File file = new File(userSchemesPath);
        if (!file.exists()) {
            file.mkdir();
            Log.log((int)5, (Object)(class$editorscheme$EditorSchemePlugin == null ? (class$editorscheme$EditorSchemePlugin = EditorSchemePlugin.class$("editorscheme.EditorSchemePlugin")) : class$editorscheme$EditorSchemePlugin), (Object)("created user schemes dir: " + userSchemesPath));
        }
    }

    public static void loadSchemes() {
        if (schemes == null) {
            schemes = new Vector();
        } else {
            schemes.removeAllElements();
        }
        EditorSchemePlugin.loadBuiltinSchemes();
        EditorSchemePlugin.loadUserSchemes();
        MiscUtilities.quicksort((Vector)schemes, (MiscUtilities.Compare)new MiscUtilities.StringICaseCompare());
    }

    public static Vector getSchemes() {
        if (schemes == null) {
            schemes = new Vector();
            EditorSchemePlugin.loadSchemes();
        }
        return schemes;
    }

    private static void loadBuiltinSchemes() {
        if (packagedSchemes == null) {
            packagedSchemes = new Vector();
            try {
                ZipFile zipFile = new ZipFile(jEdit.getPlugin((String)"editorscheme.EditorSchemePlugin").getPluginJAR().getPath());
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    if (!zipEntry.getName().endsWith(".jedit-scheme")) continue;
                    packagedSchemes.addElement(new EditorScheme(zipFile.getInputStream(zipEntry)));
                }
            }
            catch (IOException iOException) {
                Log.log((int)9, (Object)(class$editorscheme$EditorSchemePlugin == null ? (class$editorscheme$EditorSchemePlugin = EditorSchemePlugin.class$("editorscheme.EditorSchemePlugin")) : class$editorscheme$EditorSchemePlugin), (Object)("Error loading schemes from jar: " + iOException.toString()));
            }
        }
        for (int i = 0; i < packagedSchemes.size(); ++i) {
            schemes.addElement(packagedSchemes.elementAt(i));
        }
    }

    private static void loadUserSchemes() {
        File file = new File(userSchemesPath);
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".jedit-scheme");
            }
        });
        for (int i = 0; i < stringArray.length; ++i) {
            String string = file.getPath() + File.separator + stringArray[i];
            EditorScheme editorScheme = new EditorScheme(string);
            editorScheme.setReadOnly(false);
            schemes.addElement(editorScheme);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        schemes = null;
    }
}

