/*
 * Decompiled with CFR 0.152.
 */
package editorscheme;

import editorscheme.EditorScheme;
import editorscheme.EditorSchemePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.JCheckBoxList;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class EditorSchemeSelectorDialog
extends EnhancedDialog
implements ActionListener {
    private EditorScheme selectedScheme;
    private EditorScheme original;
    private JList schemeList;
    Vector schemes;
    private JCheckBox autoApply;
    private JCheckBoxList groupsList;
    private JButton closeButton;
    private JButton newButton;
    private JButton saveButton;
    private JButton selectButton;
    static /* synthetic */ Class class$editorscheme$EditorSchemePlugin;

    public EditorSchemeSelectorDialog(View view) {
        super((Frame)view, jEdit.getProperty((String)"editor-scheme.selector.title"), true);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel3);
        EditorSchemePlugin.loadSchemes();
        this.schemes = new Vector(EditorSchemePlugin.getSchemes());
        this.original = new EditorScheme();
        this.original.getFromCurrent();
        this.original.setName(jEdit.getProperty((String)"editor-scheme.selector.currentscheme"));
        this.schemes.insertElementAt(this.original, 0);
        this.schemeList = new JList(this.schemes);
        this.schemeList.setSelectionMode(0);
        this.schemeList.setCellRenderer(new EditorSchemeListCellRenderer());
        ListSelectionHandler listSelectionHandler = new ListSelectionHandler();
        this.schemeList.addListSelectionListener(listSelectionHandler);
        this.schemeList.addMouseListener(listSelectionHandler);
        jPanel.add((Component)new JLabel(jEdit.getProperty((String)"editor-scheme.schemes")), "North");
        jPanel.add((Component)new JScrollPane(this.schemeList), "Center");
        this.autoApply = new JCheckBox(jEdit.getProperty((String)"editor-scheme.autoapply.label"), jEdit.getBooleanProperty((String)"editor-scheme.autoapply", (boolean)true));
        jPanel.add((Component)this.autoApply, "South");
        jPanel2.add(jPanel);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        Vector vector = EditorScheme.getPropertyGroups();
        Object[] objectArray = new JCheckBoxList.Entry[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            EditorScheme.PropertyGroup propertyGroup = (EditorScheme.PropertyGroup)vector.elementAt(i);
            objectArray[i] = new JCheckBoxList.Entry(propertyGroup.apply, (Object)propertyGroup);
        }
        this.groupsList = new JCheckBoxList(objectArray);
        jPanel4.add((Component)new JLabel(jEdit.getProperty((String)"editor-scheme.usegroups")), "North");
        jPanel4.add((Component)new JScrollPane((Component)this.groupsList), "Center");
        jPanel2.add(jPanel4);
        jPanel3.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new EmptyBorder(12, 0, 0, 0));
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(Box.createGlue());
        this.selectButton = new JButton(jEdit.getProperty((String)"editor-scheme.select"));
        this.selectButton.setEnabled(false);
        this.selectButton.addActionListener(this);
        jPanel5.add(this.selectButton);
        jPanel5.add(Box.createHorizontalStrut(6));
        this.getRootPane().setDefaultButton(this.selectButton);
        this.newButton = new JButton(jEdit.getProperty((String)"editor-scheme.new"));
        this.newButton.addActionListener(this);
        jPanel5.add(this.newButton);
        jPanel5.add(Box.createHorizontalStrut(6));
        this.saveButton = new JButton(jEdit.getProperty((String)"editor-scheme.update"));
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(this);
        jPanel5.add(this.saveButton);
        jPanel5.add(Box.createHorizontalStrut(6));
        this.closeButton = new JButton(jEdit.getProperty((String)"editor-scheme.close"));
        this.closeButton.addActionListener(this);
        jPanel5.add(this.closeButton);
        jPanel5.add(Box.createGlue());
        jPanel3.add((Component)jPanel5, "South");
        this.pack();
        this.setLocationRelativeTo((Component)view);
        this.show();
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 300);
    }

    public void ok() {
    }

    public void cancel() {
        this.dispose();
    }

    public void selectScheme() {
        EditorScheme editorScheme = (EditorScheme)this.schemeList.getSelectedValue();
        Object[] objectArray = this.groupsList.getCheckedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            EditorScheme.PropertyGroup propertyGroup = (EditorScheme.PropertyGroup)objectArray[i];
            propertyGroup.apply(editorScheme);
        }
        jEdit.propertiesChanged();
        jEdit.saveSettings();
    }

    public void saveScheme() {
        Object[] objectArray = new String[]{this.selectedScheme.getName()};
        int n = GUIUtilities.confirm((Component)((Object)this), (String)"editor-scheme.confirm-update", (Object[])objectArray, (int)0, (int)3);
        if (n == 1) {
            return;
        }
        try {
            this.selectedScheme.getFromCurrent();
            this.selectedScheme.save();
            if (this.autoApply.isSelected()) {
                this.selectScheme();
            }
        }
        catch (IOException iOException) {
            GUIUtilities.error((Component)((Object)this), (String)"editor-scheme.saveerror", (Object[])new String[]{this.selectedScheme.getName(), iOException.toString()});
        }
    }

    void newScheme() {
        String string = "";
        String string2 = "";
        try {
            EditorScheme editorScheme;
            int n;
            string = GUIUtilities.input((Component)((Object)this), (String)"editor-scheme.save-current", (Object)"");
            if (string == null) {
                return;
            }
            string2 = MiscUtilities.constructPath((String)EditorScheme.getDefaultDir(), (String)(string.replace(' ', '_') + ".jedit-scheme"));
            File file = new File(string2);
            if (file.exists()) {
                Object[] objectArray = new String[]{file.getPath()};
                GUIUtilities.error((Component)((Object)this), (String)"editor-scheme.schemeexists", (Object[])objectArray);
                return;
            }
            EditorScheme editorScheme2 = new EditorScheme();
            editorScheme2.setName(string);
            editorScheme2.setFilename(string2);
            editorScheme2.getFromCurrent();
            editorScheme2.setReadOnly(false);
            editorScheme2.save();
            for (n = 0; n < this.schemes.size() && MiscUtilities.compareStrings((String)(editorScheme = (EditorScheme)this.schemes.elementAt(n)).getName(), (String)string, (boolean)true) <= 1; ++n) {
            }
            this.schemes.insertElementAt(editorScheme2, n);
            this.schemeList.setListData(this.schemes);
        }
        catch (IOException iOException) {
            Object[] objectArray = new String[]{string, iOException.toString()};
            GUIUtilities.error((Component)((Object)this), (String)"editor-scheme.saveerror", (Object[])objectArray);
            Log.log((int)9, (Object)(class$editorscheme$EditorSchemePlugin == null ? (class$editorscheme$EditorSchemePlugin = EditorSchemeSelectorDialog.class$("editorscheme.EditorSchemePlugin")) : class$editorscheme$EditorSchemePlugin), (Object)("error saving [" + string + "] to [" + string2 + "]: " + iOException.toString()));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            this.cancel();
        } else if (object == this.newButton) {
            this.newScheme();
        } else if (object == this.selectButton) {
            this.selectScheme();
        }
        if (object == this.saveButton) {
            this.saveScheme();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class EditorSchemeListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ImageIcon readOnlyIcon = new ImageIcon(this.getClass().getResource("/icons/readonly.gif"));
        private ImageIcon normalIcon = new ImageIcon(this.getClass().getResource("/icons/normal.gif"));

        EditorSchemeListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            EditorScheme editorScheme = (EditorScheme)object;
            String string = object.toString();
            this.setText(string);
            if (editorScheme.getReadOnly()) {
                this.setIcon(this.readOnlyIcon);
            } else {
                this.setIcon(this.normalIcon);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            return this;
        }
    }

    class ListSelectionHandler
    extends MouseAdapter
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                EditorSchemeSelectorDialog.this.selectScheme();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object e = EditorSchemeSelectorDialog.this.schemeList.getSelectedValue();
            if (e instanceof EditorScheme) {
                EditorSchemeSelectorDialog.this.selectedScheme = (EditorScheme)e;
                EditorSchemeSelectorDialog.this.saveButton.setEnabled(!EditorSchemeSelectorDialog.this.selectedScheme.getReadOnly());
                EditorSchemeSelectorDialog.this.selectButton.setEnabled(true);
                if (EditorSchemeSelectorDialog.this.autoApply.isSelected()) {
                    EditorSchemeSelectorDialog.this.selectScheme();
                }
            } else {
                EditorSchemeSelectorDialog.this.selectButton.setEnabled(false);
                EditorSchemeSelectorDialog.this.saveButton.setEnabled(false);
            }
        }
    }
}

