/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.BufferOutput;
import console.ConsoleTextField;
import console.Output;
import console.Shell;
import console.SystemShell;
import errorlist.DefaultErrorSource;
import errorlist.ErrorSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.AnimatedIcon;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;

public class Console
extends JPanel
implements EBComponent,
Output,
DefaultFocusComponent {
    private static final Icon RUN_AGAIN = GUIUtilities.loadIcon((String)"RunAgain.png");
    private static final Icon RUN = GUIUtilities.loadIcon((String)"Run.png");
    private static final Icon TO_BUFFER = GUIUtilities.loadIcon((String)"RunToBuffer.png");
    private static final Icon STOP = GUIUtilities.loadIcon((String)"Cancel.png");
    private static final Icon CLEAR = GUIUtilities.loadIcon((String)"Clear.png");
    private View view;
    private Map shellHash;
    private ShellState shellState;
    private Shell shell;
    private JComboBox shellCombo;
    private ConsoleTextField command;
    private RolloverButton runAgain;
    private RolloverButton run;
    private RolloverButton toBuffer;
    private RolloverButton stop;
    private RolloverButton clear;
    private JLabel animationLabel;
    private AnimatedIcon animation;
    private JTextPane output;
    private Color infoColor;
    private Color warningColor;
    private Color errorColor;
    private DefaultErrorSource errorSource;
    static /* synthetic */ Class class$console$Console;

    public Console(View view) {
        super(new BorderLayout());
        this.view = view;
        this.shellHash = new HashMap();
        this.initGUI();
        this.propertiesChanged();
        this.setShell("System");
    }

    public void focusOnDefaultComponent() {
        this.command.requestFocus();
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((EBComponent)this);
        SystemShell.consoleOpened(this);
        this.errorSource = new DefaultErrorSource("error parsing");
    }

    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus((EBComponent)this);
        SystemShell.consoleClosed(this);
        ErrorSource.unregisterErrorSource((ErrorSource)this.errorSource);
        this.animation.stop();
    }

    public View getView() {
        return this.view;
    }

    public Shell getShell() {
        return Shell.getShell((String)this.shellCombo.getSelectedItem());
    }

    public void setShell(String string) {
        this.setShell(Shell.getShell(string));
    }

    public void setShell(Shell shell) {
        if (shell == null) {
            throw new NullPointerException();
        }
        if (shell == this.shell) {
            return;
        }
        this.shell = shell;
        this.shellState = (ShellState)this.shellHash.get(shell.getName());
        this.shellCombo.setSelectedItem(shell.getName());
        this.command.setModel("console." + shell.getName());
        if (this.shellState != null) {
            this.output.setDocument(this.shellState.scrollback);
        } else {
            this.shellState = new ShellState(shell);
            this.output.setDocument(this.shellState.scrollback);
            this.shellHash.put(shell.getName(), this.shellState);
        }
        this.updateAnimation();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Console.this.output.setCaretPosition(Console.this.output.getDocument().getLength());
            }
        });
    }

    public HistoryTextField getTextField() {
        return this.command;
    }

    public JTextPane getOutputPane() {
        return this.output;
    }

    public void clear() {
        this.output.setText("");
        this.getShell().printInfoMessage(this.shellState);
        this.getShell().printPrompt(this, this.shellState);
    }

    public Output getOutput() {
        return this.shellState;
    }

    public void run(Shell shell, Output output, String string) {
        if (output == this) {
            output = this.shellState;
        }
        this.run(shell, this.view.getTextArea().getSelectedText(), output, this.getOutput(), string);
    }

    public void run(Shell shell, String string, Output output, Output output2, String string2) {
        Object object;
        if (string2.startsWith(":") && (object = Shell.getShell(string2.substring(1))) != null) {
            this.setShell((Shell)object);
            return;
        }
        this.setShell(shell);
        this.output.setCaretPosition(this.output.getDocument().getLength());
        object = (ShellState)this.shellHash.get(shell.getName());
        ((ShellState)object).commandRunning = true;
        this.updateAnimation();
        Macros.Recorder recorder = this.view.getMacroRecorder();
        if (recorder != null) {
            if (output instanceof BufferOutput) {
                recorder.record("runCommandToBuffer(view,\"" + shell.getName() + "\",\"" + MiscUtilities.charsToEscapes((String)string2) + "\");");
            } else {
                recorder.record("runCommandInConsole(view,\"" + shell.getName() + "\",\"" + MiscUtilities.charsToEscapes((String)string2) + "\");");
            }
        }
        HistoryModel.getModel((String)("console." + shell.getName())).addItem(string2);
        this.print(this.infoColor, "> " + string2);
        this.errorSource.clear();
        ErrorSource.unregisterErrorSource((ErrorSource)this.errorSource);
        try {
            shell.execute(this, string, output, output2, string2);
        }
        catch (RuntimeException runtimeException) {
            this.print(this.getErrorColor(), runtimeException.toString());
            Log.log((int)9, (Object)this, (Object)runtimeException);
            output.commandDone();
            output2.commandDone();
        }
    }

    public void runLastCommand() {
        HistoryModel historyModel = this.command.getModel();
        if (historyModel.getSize() == 0) {
            this.getToolkit().beep();
            return;
        }
        this.run(this.getShell(), this.getOutput(), historyModel.getItem(0));
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof PropertiesChanged) {
            this.propertiesChanged();
        } else if (eBMessage instanceof PluginUpdate) {
            this.handlePluginUpdate((PluginUpdate)eBMessage);
        }
    }

    public DefaultErrorSource getErrorSource() {
        return this.errorSource;
    }

    public Color getInfoColor() {
        return this.infoColor;
    }

    public Color getWarningColor() {
        return this.warningColor;
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public void print(Color color, String string) {
        this.getOutput().print(color, string);
    }

    public void commandDone() {
        this.getOutput().commandDone();
    }

    private void initGUI() {
        JPanel jPanel = new JPanel(new BorderLayout(6, 0));
        this.shellCombo = new JComboBox();
        this.updateShellList();
        this.shellCombo.addActionListener(new ActionHandler());
        this.shellCombo.setRequestFocusEnabled(false);
        jPanel.add("West", this.shellCombo);
        ActionHandler actionHandler = new ActionHandler();
        Box box = new Box(1);
        box.add(Box.createGlue());
        this.command = new ConsoleTextField(this.view, this, null);
        this.command.addActionListener(actionHandler);
        Dimension dimension = this.command.getPreferredSize();
        dimension.width = Integer.MAX_VALUE;
        this.command.setMaximumSize(dimension);
        box.add((Component)((Object)this.command));
        box.add(Box.createGlue());
        jPanel.add("Center", box);
        Box box2 = new Box(0);
        this.animationLabel = new JLabel();
        this.animationLabel.setBorder(new EmptyBorder(2, 3, 2, 3));
        Toolkit toolkit = this.getToolkit();
        this.animation = new AnimatedIcon(toolkit.getImage((class$console$Console == null ? (class$console$Console = Console.class$("console.Console")) : class$console$Console).getResource("/console/Blank.png")), new Image[]{toolkit.getImage((class$console$Console == null ? (class$console$Console = Console.class$("console.Console")) : class$console$Console).getResource("/console/Active1.png")), toolkit.getImage((class$console$Console == null ? (class$console$Console = Console.class$("console.Console")) : class$console$Console).getResource("/console/Active2.png")), toolkit.getImage((class$console$Console == null ? (class$console$Console = Console.class$("console.Console")) : class$console$Console).getResource("/console/Active3.png")), toolkit.getImage((class$console$Console == null ? (class$console$Console = Console.class$("console.Console")) : class$console$Console).getResource("/console/Active4.png"))}, 10, (Component)this.animationLabel);
        this.animationLabel.setIcon((Icon)this.animation);
        box2.add(this.animationLabel);
        this.runAgain = new RolloverButton(RUN_AGAIN);
        box2.add((Component)this.runAgain);
        this.runAgain.setToolTipText(jEdit.getProperty((String)"run-last-console-command.label"));
        Insets insets = new Insets(0, 0, 0, 0);
        this.runAgain.setMargin(insets);
        this.runAgain.addActionListener((ActionListener)actionHandler);
        this.runAgain.setRequestFocusEnabled(false);
        this.run = new RolloverButton(RUN);
        box2.add((Component)this.run);
        this.run.setToolTipText(jEdit.getProperty((String)"console.run"));
        insets = new Insets(0, 0, 0, 0);
        this.run.setMargin(insets);
        this.run.addActionListener((ActionListener)actionHandler);
        this.run.setRequestFocusEnabled(false);
        this.toBuffer = new RolloverButton(TO_BUFFER);
        box2.add((Component)this.toBuffer);
        this.toBuffer.setToolTipText(jEdit.getProperty((String)"console.to-buffer"));
        this.toBuffer.setMargin(insets);
        this.toBuffer.addActionListener((ActionListener)actionHandler);
        this.toBuffer.setRequestFocusEnabled(false);
        this.stop = new RolloverButton(STOP);
        box2.add((Component)this.stop);
        this.stop.setToolTipText(jEdit.getProperty((String)"console.stop"));
        this.stop.setMargin(insets);
        this.stop.addActionListener((ActionListener)actionHandler);
        this.stop.setRequestFocusEnabled(false);
        this.clear = new RolloverButton(CLEAR);
        box2.add((Component)this.clear);
        this.clear.setToolTipText(jEdit.getProperty((String)"console.clear"));
        this.clear.setMargin(insets);
        this.clear.addActionListener((ActionListener)actionHandler);
        this.clear.setRequestFocusEnabled(false);
        jPanel.add("East", box2);
        this.add("North", jPanel);
        this.output = new JTextPane();
        JScrollPane jScrollPane = new JScrollPane(this.output);
        jScrollPane.setPreferredSize(new Dimension(400, 100));
        this.add("Center", jScrollPane);
    }

    private void updateShellList() {
        String[] stringArray = Shell.getShellNames();
        Arrays.sort(stringArray, new MiscUtilities.StringICaseCompare());
        this.shellCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    private void propertiesChanged() {
        this.output.setBackground(jEdit.getColorProperty((String)"console.bgColor"));
        this.output.setForeground(jEdit.getColorProperty((String)"console.plainColor"));
        this.output.setFont(jEdit.getFontProperty((String)"console.font"));
        this.infoColor = jEdit.getColorProperty((String)"console.infoColor");
        this.warningColor = jEdit.getColorProperty((String)"console.warningColor");
        this.errorColor = jEdit.getColorProperty((String)"console.errorColor");
    }

    public void handlePluginUpdate(PluginUpdate pluginUpdate) {
        if (pluginUpdate.getWhat() == PluginUpdate.LOADED || pluginUpdate.getWhat() == PluginUpdate.UNLOADED) {
            this.updateShellList();
            this.shellCombo.setSelectedItem(this.shell.getName());
            Iterator iterator = this.shellHash.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (Shell.getShell(string) != null) continue;
                iterator.remove();
            }
        }
    }

    private void updateAnimation() {
        if (this.shellState.commandRunning) {
            this.animation.start();
        } else {
            this.animation.stop();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$300(Console console) {
        console.updateAnimation();
    }

    static /* synthetic */ DefaultErrorSource access$400(Console console) {
        return console.errorSource;
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == Console.this.shellCombo) {
                Console.this.setShell((String)Console.this.shellCombo.getSelectedItem());
            } else if (object == Console.this.command || object == Console.this.run) {
                String string = Console.this.command.getText();
                if (string == null || string.length() == 0) {
                    return;
                }
                Console.this.command.setText(null);
                Console.this.run(Console.this.getShell(), Console.this, string);
            } else if (object == Console.this.runAgain) {
                Console.this.runLastCommand();
            } else if (object == Console.this.toBuffer) {
                String string = Console.this.command.getText();
                if (string == null || string.length() == 0) {
                    return;
                }
                Console.this.command.setText(null);
                Console.this.run(Console.this.getShell(), new BufferOutput(Console.this), string);
            } else if (object == Console.this.stop) {
                Console.this.getShell().stop(Console.this);
            } else if (object == Console.this.clear) {
                Console.this.clear();
            }
        }
    }

    public class ShellState
    implements Output {
        Shell shell;
        Document scrollback;
        boolean commandRunning;

        ShellState(Shell shell) {
            this.shell = shell;
            this.scrollback = new DefaultStyledDocument();
            shell.printInfoMessage(this);
            shell.printPrompt(Console.this, this);
        }

        public void print(Color color, String string) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.printSafely(color, string);
            } else {
                SwingUtilities.invokeLater(new Runnable(this, color, string){
                    private final /* synthetic */ Color val$color;
                    private final /* synthetic */ String val$msg;
                    private final /* synthetic */ ShellState this$1;
                    {
                        this.this$1 = shellState;
                        this.val$color = color;
                        this.val$msg = string;
                    }

                    public void run() {
                        ShellState.access$100(this.this$1, this.val$color, this.val$msg);
                    }
                });
            }
        }

        public void commandDone() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ ShellState this$1;
                {
                    this.this$1 = shellState;
                }

                public void run() {
                    if (this.this$1.commandRunning) {
                        this.this$1.shell.printPrompt(ShellState.access$200(this.this$1), this.this$1);
                    }
                    this.this$1.commandRunning = false;
                    Console.access$300(ShellState.access$200(this.this$1));
                    if (Console.access$400(ShellState.access$200(this.this$1)).getErrorCount() != 0) {
                        ErrorSource.registerErrorSource((ErrorSource)Console.access$400(ShellState.access$200(this.this$1)));
                    }
                }
            });
        }

        private void printSafely(Color color, String string) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            if (color != null) {
                simpleAttributeSet.addAttribute(StyleConstants.Foreground, color);
            } else {
                simpleAttributeSet.addAttribute(StyleConstants.Foreground, Console.this.output.getForeground());
            }
            try {
                this.scrollback.insertString(this.scrollback.getLength(), string, simpleAttributeSet);
                this.scrollback.insertString(this.scrollback.getLength(), "\n", simpleAttributeSet);
            }
            catch (BadLocationException badLocationException) {
                Log.log((int)9, (Object)this, (Object)badLocationException);
            }
        }

        static /* synthetic */ void access$100(ShellState shellState, Color color, String string) {
            shellState.printSafely(color, string);
        }

        static /* synthetic */ Console access$200(ShellState shellState) {
            return shellState.Console.this;
        }
    }
}

