/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.ConsoleToolBar;
import console.ErrorMatcher;
import console.SystemShell;
import console.commando.CommandoCommand;
import console.commando.CommandoToolBar;
import errorlist.DefaultErrorSource;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JToolBar;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.util.Log;

public class ConsolePlugin
extends EBPlugin {
    public static final String MENU = "plugin.console.ConsolePlugin.menu";
    public static final String CMD_PATH = "/console/bsh/";
    public static final int NO_ERROR = -1;
    private static ErrorMatcher[] errorMatchers;
    private static ErrorMatcher lastMatcher;
    private static DefaultErrorSource.DefaultError lastError;
    private static String consoleDirectory;
    private static String commandoDirectory;
    private static ActionSet commando;
    private Hashtable consoleToolBarMap;
    private Hashtable commandoToolBarMap;
    static /* synthetic */ Class class$console$ConsolePlugin;

    public static SystemShell getSystemShell() {
        return (SystemShell)ServiceManager.getService((String)"console.Shell", (String)"System");
    }

    public void start() {
        View[] viewArray;
        BeanShell.getNameSpace().addCommandPath(CMD_PATH, ((Object)((Object)this)).getClass());
        String string = jEdit.getSettingsDirectory();
        if (string != null && !(viewArray = new File(commandoDirectory = MiscUtilities.constructPath((String)(consoleDirectory = MiscUtilities.constructPath((String)string, (String)"console")), (String)"commando"))).exists()) {
            viewArray.mkdirs();
        }
        this.consoleToolBarMap = new Hashtable();
        this.commandoToolBarMap = new Hashtable();
        commando = new ActionSet(jEdit.getProperty((String)"action-set.commando.label"));
        jEdit.addActionSet((ActionSet)commando);
        ConsolePlugin.rescanCommandoDirectory();
        viewArray = jEdit.getViews();
        for (int i = 0; i < viewArray.length; ++i) {
            this.viewOpened(viewArray[i]);
        }
        this.propertiesChanged();
    }

    public void stop() {
        BeanShell.getNameSpace().addCommandPath(CMD_PATH, ((Object)((Object)this)).getClass());
        View[] viewArray = jEdit.getViews();
        for (int i = 0; i < viewArray.length; ++i) {
            this.viewClosed(viewArray[i]);
        }
        jEdit.removeActionSet((ActionSet)commando);
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof ViewUpdate) {
            ViewUpdate viewUpdate = (ViewUpdate)eBMessage;
            View view = viewUpdate.getView();
            if (viewUpdate.getWhat() == ViewUpdate.CREATED) {
                this.viewOpened(view);
            } else if (viewUpdate.getWhat() == ViewUpdate.CLOSED) {
                this.viewClosed(view);
            }
        } else if (eBMessage instanceof PropertiesChanged) {
            this.propertiesChanged();
        }
    }

    public static String getConsoleSettingsDirectory() {
        return consoleDirectory;
    }

    public static String getCommandoDirectory() {
        return commandoDirectory;
    }

    public static void rescanCommandoDirectory() {
        String string;
        EditAction editAction;
        int n;
        Object[] objectArray;
        commando.removeAllActions();
        StringTokenizer stringTokenizer = new StringTokenizer(jEdit.getProperty((String)"commando.default"));
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            commando.addAction((EditAction)new CommandoCommand(objectArray.replace('_', ' '), (class$console$ConsolePlugin == null ? ConsolePlugin.class$("console.ConsolePlugin") : class$console$ConsolePlugin).getResource("/console/commando/" + (String)objectArray + ".xml")));
        }
        if (commandoDirectory != null && (objectArray = new File(commandoDirectory).listFiles()) != null) {
            for (n = 0; n < objectArray.length; ++n) {
                editAction = objectArray[n];
                string = editAction.getName();
                if (!string.endsWith(".xml") || editAction.isHidden()) continue;
                commando.addAction((EditAction)new CommandoCommand(string.substring(0, string.length() - 4).replace('_', ' '), editAction.getPath()));
            }
        }
        objectArray = ConsolePlugin.getCommandoCommands();
        for (n = 0; n < objectArray.length; ++n) {
            String string2;
            editAction = objectArray[n];
            string = jEdit.getProperty((String)(editAction.getName() + ".shortcut"));
            if (string != null) {
                jEdit.getInputHandler().addKeyBinding(string, editAction);
            }
            if ((string2 = jEdit.getProperty((String)(editAction.getName() + ".shortcut2"))) == null) continue;
            jEdit.getInputHandler().addKeyBinding(string2, editAction);
        }
        EditBus.send((EBMessage)new DynamicMenuChanged(MENU));
    }

    public static EditAction[] getCommandoCommands() {
        Object[] objectArray = commando.getActions();
        MiscUtilities.quicksort((Object[])objectArray, (MiscUtilities.Compare)new ActionCompare());
        return objectArray;
    }

    public static void compile(View view, Buffer buffer) {
        String string = buffer.getStringProperty("commando.compile");
        if (string == null || string.length() == 0) {
            GUIUtilities.error((Component)view, (String)"commando.no-compiler", null);
            return;
        }
        CommandoCommand commandoCommand = (CommandoCommand)commando.getAction("commando." + string);
        if (commandoCommand == null) {
            GUIUtilities.error((Component)view, (String)"commando.no-command", (Object[])new String[]{string});
        } else {
            Object[] objectArray;
            int n;
            if (buffer.isDirty() && ((n = GUIUtilities.confirm((Component)view, (String)"commando.not-saved-compile", (Object[])(objectArray = new Object[]{buffer.getName()}), (int)1, (int)2)) == 0 ? !buffer.save(view, null, true) : n != 1)) {
                return;
            }
            commandoCommand.invoke(view);
        }
    }

    public static void run(View view, Buffer buffer) {
        String string = buffer.getStringProperty("commando.run");
        if (string == null || string.length() == 0) {
            GUIUtilities.error((Component)view, (String)"commando.no-interpreter", null);
            return;
        }
        CommandoCommand commandoCommand = (CommandoCommand)commando.getAction("commando." + string);
        if (commandoCommand == null) {
            GUIUtilities.error((Component)view, (String)"commando.no-command", (Object[])new String[]{string});
        } else {
            Object[] objectArray;
            int n;
            if (buffer.isDirty() && ((n = GUIUtilities.confirm((Component)view, (String)"commando.not-saved-run", (Object[])(objectArray = new Object[]{buffer.getName()}), (int)1, (int)2)) == 0 ? !buffer.save(view, null, true) : n != 1)) {
                return;
            }
            commandoCommand.invoke(view);
        }
    }

    public static String getPackageName(Buffer buffer) {
        StringReader stringReader = new StringReader(buffer.getText(0, buffer.getLength()));
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
            streamTokenizer.slashStarComments(true);
            streamTokenizer.slashSlashComments(true);
            while (streamTokenizer.nextToken() != -1) {
                if (streamTokenizer.sval == null) continue;
                if (streamTokenizer.sval.equals("package")) {
                    streamTokenizer.nextToken();
                    stringReader.close();
                    return streamTokenizer.sval;
                }
                if (!streamTokenizer.sval.equals("class")) continue;
                stringReader.close();
                return null;
            }
            stringReader.close();
        }
        catch (IOException iOException) {
            throw new InternalError();
        }
        return null;
    }

    public static String getClassName(Buffer buffer) {
        String string = ConsolePlugin.getPackageName(buffer);
        String string2 = MiscUtilities.getFileNameNoExtension((String)buffer.getPath());
        if (string == null) {
            return string2;
        }
        return string + '.' + string2;
    }

    public static String getPackageRoot(Buffer buffer) {
        String string = ConsolePlugin.getPackageName(buffer);
        String string2 = MiscUtilities.getParentOfPath((String)buffer.getPath());
        if (string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string == null) {
            return string2;
        }
        if (string2.endsWith(string = string.replace('.', File.separatorChar))) {
            return string2.substring(0, string2.length() - string.length());
        }
        return string2;
    }

    public static String expandSystemShellVariables(View view, String string) {
        return ConsolePlugin.getSystemShell().expandVariables(view, string);
    }

    public static String getSystemShellVariableValue(View view, String string) {
        return ConsolePlugin.getSystemShell().getVariableValue(view, string);
    }

    public static void setSystemShellVariableValue(String string, String string2) {
        ConsolePlugin.getSystemShell().getVariables().put(string, string2);
    }

    public static synchronized int parseLine(String string, String string2, DefaultErrorSource defaultErrorSource) {
        return ConsolePlugin.parseLine(jEdit.getLastView(), string, string2, defaultErrorSource);
    }

    public static synchronized int parseLine(View view, String string, String string2, DefaultErrorSource defaultErrorSource) {
        if (errorMatchers == null) {
            ConsolePlugin.loadMatchers();
        }
        if (lastError != null) {
            String string3 = null;
            if (lastMatcher != null && lastMatcher.match(view, string, string2, defaultErrorSource) == null) {
                string3 = lastMatcher.matchExtra(string);
            }
            if (string3 != null) {
                lastError.addExtraMessage(string3);
                return lastError.getErrorType();
            }
            defaultErrorSource.addError(lastError);
            lastMatcher = null;
            lastError = null;
        }
        for (int i = 0; i < errorMatchers.length; ++i) {
            ErrorMatcher errorMatcher = errorMatchers[i];
            DefaultErrorSource.DefaultError defaultError = errorMatcher.match(view, string, string2, defaultErrorSource);
            if (defaultError == null) continue;
            lastError = defaultError;
            lastMatcher = errorMatcher;
            return defaultError.getErrorType();
        }
        return -1;
    }

    public static ErrorMatcher[] getErrorMatchers() {
        if (errorMatchers == null) {
            ConsolePlugin.loadMatchers();
        }
        return errorMatchers;
    }

    public static synchronized void finishErrorParsing(DefaultErrorSource defaultErrorSource) {
        if (lastError != null) {
            defaultErrorSource.addError(lastError);
            lastError = null;
            lastMatcher = null;
        }
    }

    private void viewOpened(View view) {
        JToolBar jToolBar;
        if (view.isPlainView()) {
            return;
        }
        if (jEdit.getBooleanProperty((String)"console.toolbar.enabled")) {
            jToolBar = new ConsoleToolBar(view);
            this.consoleToolBarMap.put(view, jToolBar);
            view.addToolBar((Component)jToolBar);
        }
        if (jEdit.getBooleanProperty((String)"commando.toolbar.enabled")) {
            jToolBar = new CommandoToolBar(view);
            this.commandoToolBarMap.put(view, jToolBar);
            view.addToolBar((Component)jToolBar);
        }
    }

    private void viewClosed(View view) {
        this.consoleToolBarMap.remove(view);
        this.commandoToolBarMap.remove(view);
    }

    private void propertiesChanged() {
        JToolBar jToolBar;
        Object object;
        int n;
        Object object2;
        errorMatchers = null;
        if (jEdit.getBooleanProperty((String)"console.toolbar.enabled")) {
            object2 = jEdit.getViews();
            for (n = 0; n < ((Object)object2).length; ++n) {
                object = object2[n];
                if (this.consoleToolBarMap.containsKey(object)) continue;
                jToolBar = new ConsoleToolBar((View)object);
                this.consoleToolBarMap.put(object, jToolBar);
                object.addToolBar((Component)jToolBar);
            }
        } else {
            object2 = this.consoleToolBarMap.keys();
            while (object2.hasMoreElements()) {
                View view = (View)object2.nextElement();
                object = (ConsoleToolBar)this.consoleToolBarMap.get(view);
                view.removeToolBar((Component)object);
            }
            this.consoleToolBarMap.clear();
        }
        if (jEdit.getBooleanProperty((String)"commando.toolbar.enabled")) {
            object2 = jEdit.getViews();
            for (n = 0; n < ((Object)object2).length; ++n) {
                object = object2[n];
                if (this.commandoToolBarMap.containsKey(object)) continue;
                jToolBar = new CommandoToolBar((View)object);
                this.commandoToolBarMap.put(object, jToolBar);
                object.addToolBar((Component)jToolBar);
            }
        } else {
            object2 = this.commandoToolBarMap.keys();
            while (object2.hasMoreElements()) {
                View view = (View)object2.nextElement();
                object = (CommandoToolBar)this.commandoToolBarMap.get(view);
                view.removeToolBar((Component)object);
            }
            this.commandoToolBarMap.clear();
        }
    }

    private static void loadMatchers() {
        lastMatcher = null;
        Vector vector = new Vector();
        ConsolePlugin.loadMatchers(true, jEdit.getProperty((String)"console.error.user"), vector);
        ConsolePlugin.loadMatchers(false, jEdit.getProperty((String)"console.error.default"), vector);
        errorMatchers = new ErrorMatcher[vector.size()];
        vector.copyInto(errorMatchers);
    }

    private static void loadMatchers(boolean bl, String string, Vector vector) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            ConsolePlugin.loadMatcher(bl, stringTokenizer.nextToken(), vector);
        }
    }

    private static void loadMatcher(boolean bl, String string, Vector vector) {
        String string2 = jEdit.getProperty((String)("console.error." + string + ".name"));
        String string3 = jEdit.getProperty((String)("console.error." + string + ".match"));
        String string4 = jEdit.getProperty((String)("console.error." + string + ".warning"));
        String string5 = jEdit.getProperty((String)("console.error." + string + ".extra"));
        String string6 = jEdit.getProperty((String)("console.error." + string + ".filename"));
        String string7 = jEdit.getProperty((String)("console.error." + string + ".line"));
        String string8 = jEdit.getProperty((String)("console.error." + string + ".message"));
        try {
            ErrorMatcher errorMatcher = new ErrorMatcher(bl, string, string2, string3, string4, string5, string6, string7, string8);
            vector.addElement(errorMatcher);
        }
        catch (Exception exception) {
            Log.log((int)9, (Object)(class$console$ConsolePlugin == null ? (class$console$ConsolePlugin = ConsolePlugin.class$("console.ConsolePlugin")) : class$console$ConsolePlugin), (Object)("Invalid regexp in matcher " + string));
            Log.log((int)9, (Object)(class$console$ConsolePlugin == null ? (class$console$ConsolePlugin = ConsolePlugin.class$("console.ConsolePlugin")) : class$console$ConsolePlugin), (Object)exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ActionCompare
    implements MiscUtilities.Compare {
        ActionCompare() {
        }

        public int compare(Object object, Object object2) {
            EditAction editAction = (EditAction)object;
            EditAction editAction2 = (EditAction)object2;
            return editAction.getLabel().compareTo(editAction2.getLabel());
        }
    }
}

