/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.ConsolePlugin;
import console.Output;
import console.ProcessRunner;
import console.SystemShell;
import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Stack;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.RESearchMatcher;
import org.gjt.sp.util.Log;

class ConsoleProcess {
    private static RE makeEntering;
    private static RE makeLeaving;
    private SystemShell.ConsoleState consoleState;
    private String currentDirectory;
    private Stack currentDirectoryStack;
    private Console console;
    private Output output;
    private Output error;
    private String[] args;
    private String[] env;
    private Process process;
    private InputThread stdin;
    private StreamThread stdout;
    private StreamThread stderr;
    private int threadDoneCount;
    private int exitCode;
    private boolean stopped;
    static /* synthetic */ Class class$console$ConsoleProcess;
    static /* synthetic */ Class class$console$ConsoleProcess$InputThread;
    static /* synthetic */ Class class$console$ConsoleProcess$StreamThread;

    ConsoleProcess(Console console, String string, Output output, Output output2, String[] stringArray, String[] stringArray2, boolean bl) {
        SystemShell.ConsoleState consoleState = SystemShell.getConsoleState(console);
        this.args = stringArray;
        this.env = stringArray2;
        this.currentDirectory = consoleState.currentDirectory;
        this.currentDirectoryStack = new Stack();
        this.currentDirectoryStack.push(this.currentDirectory);
        if (bl) {
            console.getErrorSource().clear();
            this.console = console;
            this.output = output;
            this.error = output2;
            this.consoleState = consoleState;
            ConsoleProcess consoleProcess = consoleState.process;
            if (consoleProcess != null) {
                consoleProcess.stop();
            }
            consoleState.process = this;
        }
        try {
            this.process = ProcessRunner.getProcessRunner().exec(stringArray, stringArray2, this.currentDirectory);
            this.stdin = new InputThread(string, this.process.getOutputStream());
            this.stdin.start();
            this.stdout = new StreamThread(this.process.getInputStream());
            this.stdout.start();
            this.stderr = new StreamThread(this.process.getErrorStream());
            this.stderr.start();
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{exception.toString()};
            output2.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.error", (Object[])objectArray));
            output.commandDone();
            output2.commandDone();
            this.stop();
        }
    }

    void detach() {
        if (this.console != null) {
            Object[] objectArray = new Object[]{this.args[0]};
            this.error.print(this.console.getErrorColor(), jEdit.getProperty((String)"console.shell.detached", (Object[])objectArray));
            this.output.commandDone();
            this.error.commandDone();
        }
        this.consoleState.process = null;
        this.consoleState = null;
        this.console = null;
    }

    void stop() {
        if (this.process != null) {
            this.stopped = true;
            this.stdin.abort();
            this.stdout.abort();
            this.stderr.abort();
            this.process.destroy();
            this.process = null;
            if (this.console != null) {
                Object[] objectArray = new Object[]{this.args[0]};
                this.error.print(this.console.getErrorColor(), jEdit.getProperty((String)"console.shell.killed", (Object[])objectArray));
            }
            ConsolePlugin.finishErrorParsing(this.console.getErrorSource());
            this.output.commandDone();
            this.error.commandDone();
        }
        if (this.consoleState != null) {
            this.consoleState.process = null;
        }
    }

    boolean getExitStatus() {
        return this.exitCode == 0;
    }

    private synchronized void threadDone() {
        ++this.threadDoneCount;
        if (this.process != null && this.threadDoneCount == 3) {
            if (!this.stopped) {
                try {
                    this.exitCode = this.process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    Log.log((int)9, (Object)this, (Object)interruptedException);
                    this.notifyAll();
                    return;
                }
            }
            if (this.console != null && this.output != null && this.error != null) {
                Object[] objectArray = new Object[]{this.args[0], new Integer(this.exitCode)};
                String string = jEdit.getProperty((String)"console.shell.exited", (Object[])objectArray);
                if (this.exitCode == 0) {
                    this.error.print(this.console.getInfoColor(), string);
                } else {
                    this.error.print(this.console.getErrorColor(), string);
                }
                ConsolePlugin.finishErrorParsing(this.console.getErrorSource());
                this.output.commandDone();
                this.error.commandDone();
            }
            this.process = null;
            if (this.consoleState != null) {
                this.consoleState.process = null;
            }
            this.notifyAll();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            makeEntering = new RE((Object)jEdit.getProperty((String)"console.error.make.entering"), 0, RESearchMatcher.RE_SYNTAX_JEDIT);
            makeLeaving = new RE((Object)jEdit.getProperty((String)"console.error.make.leaving"), 0, RESearchMatcher.RE_SYNTAX_JEDIT);
        }
        catch (REException rEException) {
            Log.log((int)9, (Object)(class$console$ConsoleProcess == null ? (class$console$ConsoleProcess = ConsoleProcess.class$("console.ConsoleProcess")) : class$console$ConsoleProcess), (Object)((Object)rEException));
        }
    }

    class StreamThread
    extends Thread {
        boolean aborted;
        BufferedReader in;

        StreamThread(InputStream inputStream) {
            this.setName("" + (class$console$ConsoleProcess$StreamThread == null ? (class$console$ConsoleProcess$StreamThread = ConsoleProcess.class$("console.ConsoleProcess$StreamThread")) : class$console$ConsoleProcess$StreamThread) + ConsoleProcess.this.args);
            this.in = new BufferedReader(new InputStreamReader(inputStream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String string;
                while ((string = this.in.readLine()) != null) {
                    if (ConsoleProcess.this.console == null || ConsoleProcess.this.output == null) continue;
                    if (this.aborted) break;
                    Color color = null;
                    REMatch rEMatch = makeEntering.getMatch((Object)string);
                    if (rEMatch == null) {
                        rEMatch = makeLeaving.getMatch((Object)string);
                        if (rEMatch == null) {
                            String string2 = ConsoleProcess.this.currentDirectoryStack.isEmpty() ? ConsoleProcess.this.currentDirectory : (String)ConsoleProcess.this.currentDirectoryStack.peek();
                            int n = ConsolePlugin.parseLine(ConsoleProcess.this.console.getView(), string, string2, ConsoleProcess.this.console.getErrorSource());
                            switch (n) {
                                case 0: {
                                    color = ConsoleProcess.this.console.getErrorColor();
                                    break;
                                }
                                case 1: {
                                    color = ConsoleProcess.this.console.getWarningColor();
                                }
                            }
                        } else if (!ConsoleProcess.this.currentDirectoryStack.isEmpty()) {
                            ConsoleProcess.this.currentDirectoryStack.pop();
                        }
                    } else {
                        ConsoleProcess.this.currentDirectoryStack.push(rEMatch.toString(1));
                    }
                    ConsoleProcess.this.output.print(color, string);
                }
                this.in.close();
            }
            catch (Exception exception) {
                if (!this.aborted) {
                    Log.log((int)9, (Object)this, (Object)exception);
                    if (ConsoleProcess.this.console != null) {
                        Object[] objectArray = new String[]{exception.toString()};
                        ConsoleProcess.this.error.print(ConsoleProcess.this.console.getErrorColor(), jEdit.getProperty((String)"console.shell.error", (Object[])objectArray));
                    }
                }
                try {
                    this.in.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            finally {
                ConsoleProcess.this.threadDone();
            }
        }

        public void abort() {
            this.aborted = true;
        }
    }

    class InputThread
    extends Thread {
        boolean aborted;
        String input;
        BufferedWriter out;
        String lineSep;

        InputThread(String string, OutputStream outputStream) {
            this.setName("" + (class$console$ConsoleProcess$InputThread == null ? (class$console$ConsoleProcess$InputThread = ConsoleProcess.class$("console.ConsoleProcess$InputThread")) : class$console$ConsoleProcess$InputThread) + ConsoleProcess.this.args);
            this.input = string;
            this.out = new BufferedWriter(new OutputStreamWriter(outputStream));
            this.lineSep = System.getProperty("line.separator");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (this.input != null) {
                    for (int i = 0; i < this.input.length(); ++i) {
                        char c = this.input.charAt(i);
                        if (c == '\n') {
                            this.out.write(this.lineSep);
                            continue;
                        }
                        this.out.write(c);
                    }
                }
                this.out.close();
            }
            catch (Exception exception) {
                if (!this.aborted) {
                    Log.log((int)9, (Object)this, (Object)exception);
                    if (ConsoleProcess.this.console != null) {
                        Object[] objectArray = new String[]{exception.toString()};
                        ConsoleProcess.this.error.print(ConsoleProcess.this.console.getErrorColor(), jEdit.getProperty((String)"console.shell.error", (Object[])objectArray));
                    }
                }
                try {
                    this.out.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            finally {
                ConsoleProcess.this.threadDone();
            }
        }

        public void abort() {
            this.aborted = true;
        }
    }
}

