/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.ConsoleToolBar;
import console.ProcessRunner;
import console.Shell;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.jEdit;

public class ConsoleTextField
extends HistoryTextField {
    private View view;
    private Console console;
    private ConsoleToolBar toolBar;

    public ConsoleTextField(View view, Console console, ConsoleToolBar consoleToolBar) {
        super(null);
        this.view = view;
        this.console = console;
        this.toolBar = consoleToolBar;
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 9) {
            this.complete();
            return;
        }
        super.processKeyEvent(keyEvent);
    }

    private void complete() {
        Shell shell = this.toolBar != null ? this.toolBar.getShell() : this.console.getShell();
        Shell.CompletionInfo completionInfo = shell.getCompletions(this.console, this.getText().substring(0, this.getCaretPosition()));
        if (completionInfo == null || completionInfo.completions.length == 0) {
            this.getToolkit().beep();
        } else if (completionInfo.completions.length == 1) {
            this.select(completionInfo.offset, this.getCaretPosition());
            this.replaceSelection(completionInfo.completions[0]);
        } else {
            Console console;
            String string = MiscUtilities.getLongestPrefix((String[])completionInfo.completions, (boolean)ProcessRunner.getProcessRunner().isCaseSensitive());
            if (string.length() != 0 && this.getCaretPosition() - completionInfo.offset != string.length()) {
                this.select(completionInfo.offset, this.getCaretPosition());
                this.replaceSelection(string);
                return;
            }
            if (this.console == null) {
                this.view.getDockableWindowManager().addDockableWindow("console");
                console = (Console)this.view.getDockableWindowManager().getDockable("console");
                console.getTextField().setText(this.getText());
                console.getTextField().setCaretPosition(this.getCaretPosition());
                this.setText(null);
            } else {
                console = this.console;
            }
            console.print(this.console.getInfoColor(), jEdit.getProperty((String)"console.completions"));
            Arrays.sort(completionInfo.completions, new MiscUtilities.StringICaseCompare());
            for (int i = 0; i < completionInfo.completions.length; ++i) {
                console.print(null, completionInfo.completions[i]);
            }
            console.print(this.console.getInfoColor(), jEdit.getProperty((String)"console.completions-end"));
        }
    }
}

