/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.ConsolePlugin;
import console.ConsoleTextField;
import console.Shell;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JToolBar;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowManager;

class ConsoleToolBar
extends JToolBar {
    private View view;
    private JComboBox shellCombo;
    private ConsoleTextField cmd;

    public ConsoleToolBar(View view) {
        this.setLayout(new BorderLayout(6, 0));
        this.setFloatable(false);
        this.view = view;
        String[] stringArray = Shell.getShellNames();
        Arrays.sort(stringArray, new MiscUtilities.StringICaseCompare());
        this.shellCombo = new JComboBox<String>(stringArray);
        this.add("West", this.shellCombo);
        this.shellCombo.setSelectedItem(ConsolePlugin.getSystemShell());
        this.shellCombo.addActionListener(new ActionHandler());
        Box box = new Box(1);
        box.add(Box.createGlue());
        this.cmd = new ConsoleTextField(view, null, this);
        Dimension dimension = this.cmd.getPreferredSize();
        dimension.width = Integer.MAX_VALUE;
        this.cmd.setMaximumSize(dimension);
        box.add((Component)((Object)this.cmd));
        box.add(Box.createGlue());
        this.add("Center", box);
        this.cmd.setModel("console." + this.shellCombo.getSelectedItem());
        this.cmd.addActionListener(new ActionHandler());
    }

    public Shell getShell() {
        return Shell.getShell((String)this.shellCombo.getSelectedItem());
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ConsoleToolBar.this.shellCombo) {
                ConsoleToolBar.this.cmd.setModel("console." + ConsoleToolBar.this.shellCombo.getSelectedItem());
            } else if (actionEvent.getSource() == ConsoleToolBar.this.cmd) {
                DockableWindowManager dockableWindowManager = ConsoleToolBar.this.view.getDockableWindowManager();
                dockableWindowManager.addDockableWindow("console");
                String string = ConsoleToolBar.this.cmd.getText();
                if (string != null && string.length() != 0) {
                    ConsoleToolBar.this.cmd.addCurrentToHistory();
                    ConsoleToolBar.this.cmd.setText(null);
                    Console console = (Console)dockableWindowManager.getDockable("console");
                    console.setShell((String)ConsoleToolBar.this.shellCombo.getSelectedItem());
                    console.run(console.getShell(), console, string);
                }
            }
        }
    }
}

