/*
 * Decompiled with CFR 0.152.
 */
package console;

import errorlist.DefaultErrorSource;
import errorlist.ErrorSource;
import gnu.regexp.RE;
import gnu.regexp.REException;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.RESearchMatcher;

public class ErrorMatcher
implements Cloneable {
    public boolean user;
    public String internalName;
    public String name;
    public String error;
    public String warning;
    public String extra;
    public String filename;
    public String line;
    public String message;
    public RE errorRE;
    public RE warningRE;
    public RE extraRE;

    public ErrorMatcher(boolean bl, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws REException {
        this.user = bl;
        this.internalName = string;
        this.name = string2;
        this.error = string3;
        this.warning = string4;
        this.extra = string5;
        this.filename = string6;
        this.line = string7;
        this.message = string8;
        this.errorRE = new RE((Object)string3, 2, RESearchMatcher.RE_SYNTAX_JEDIT);
        if (string4 != null && string4.length() != 0) {
            this.warningRE = new RE((Object)string4, 2, RESearchMatcher.RE_SYNTAX_JEDIT);
        }
        if (string5 != null && string5.length() != 0) {
            this.extraRE = new RE((Object)string5, 2, RESearchMatcher.RE_SYNTAX_JEDIT);
        }
    }

    public ErrorMatcher() {
    }

    public DefaultErrorSource.DefaultError match(View view, String string, String string2, DefaultErrorSource defaultErrorSource) {
        int n;
        RE rE;
        if (this.warningRE != null && this.warningRE.isMatch((Object)string)) {
            rE = this.warningRE;
            n = 1;
        } else if (this.errorRE.isMatch((Object)string)) {
            rE = this.errorRE;
            n = 0;
        } else {
            return null;
        }
        String string3 = this.filename.equals("$f") ? view.getBuffer().getPath() : MiscUtilities.constructPath((String)string2, (String)rE.substitute((Object)string, this.filename));
        String string4 = rE.substitute((Object)string, this.line);
        String string5 = rE.substitute((Object)string, this.message);
        try {
            return new DefaultErrorSource.DefaultError((ErrorSource)defaultErrorSource, n, string3, Math.max(0, Integer.parseInt(string4) - 1), 0, 0, string5);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String matchExtra(String string) {
        if (this.extraRE != null && this.extraRE.isMatch((Object)string)) {
            return this.extraRE.substitute((Object)string, "$1");
        }
        return null;
    }

    public void save() {
        jEdit.setProperty((String)("console.error." + this.internalName + ".name"), (String)this.name);
        jEdit.setProperty((String)("console.error." + this.internalName + ".match"), (String)this.error);
        jEdit.setProperty((String)("console.error." + this.internalName + ".warning"), (String)this.warning);
        jEdit.setProperty((String)("console.error." + this.internalName + ".extra"), (String)this.extra);
        jEdit.setProperty((String)("console.error." + this.internalName + ".filename"), (String)this.filename);
        jEdit.setProperty((String)("console.error." + this.internalName + ".line"), (String)this.line);
        jEdit.setProperty((String)("console.error." + this.internalName + ".message"), (String)this.message);
    }

    public String toString() {
        return this.name;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

