/*
 * Decompiled with CFR 0.152.
 */
package console;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

abstract class ProcessRunner {
    private static ProcessRunner instance;
    static /* synthetic */ Class class$console$ProcessRunner;

    ProcessRunner() {
    }

    abstract boolean shellExpandsGlobs();

    abstract boolean supportsEnvironmentVariables();

    abstract Hashtable getEnvironmentVariables();

    void setUpDefaultAliases(Hashtable hashtable) {
    }

    abstract boolean isCaseSensitive();

    Process exec(String[] stringArray, String[] stringArray2, String string) throws Exception {
        return Runtime.getRuntime().exec(stringArray, stringArray2, new File(string));
    }

    static ProcessRunner getProcessRunner() {
        if (instance == null) {
            if (OperatingSystem.isWindows9x()) {
                instance = new Windows9x();
            } else if (OperatingSystem.isWindowsNT()) {
                instance = new WindowsNT();
            } else if (OperatingSystem.isUnix()) {
                instance = new Unix();
            } else {
                Log.log((int)7, (Object)(class$console$ProcessRunner == null ? (class$console$ProcessRunner = ProcessRunner.class$("console.ProcessRunner")) : class$console$ProcessRunner), (Object)"Unknown operating system");
                instance = new Generic();
            }
        }
        return instance;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class WindowsNT
    extends Windows {
        WindowsNT() {
        }

        boolean supportsEnvironmentVariables() {
            return true;
        }

        Hashtable getEnvironmentVariables() {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            try {
                String string;
                Process process = Runtime.getRuntime().exec("cmd.exe /c set");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string = bufferedReader.readLine()) != null) {
                    Log.log((int)1, (Object)this, (Object)string);
                    int n = string.indexOf(61);
                    if (n == -1) continue;
                    hashtable.put(string.substring(0, n), string.substring(n + 1));
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Log.log((int)9, (Object)this, (Object)iOException);
            }
            return hashtable;
        }

        Process exec(String[] stringArray, String[] stringArray2, String string) throws Exception {
            String[] stringArray3 = new String[]{"cmd.exe", "/c"};
            String[] stringArray4 = new String[stringArray3.length + stringArray.length];
            System.arraycopy(stringArray3, 0, stringArray4, 0, stringArray3.length);
            System.arraycopy(stringArray, 0, stringArray4, stringArray3.length, stringArray.length);
            return super.exec(stringArray4, stringArray2, string);
        }
    }

    static class Windows9x
    extends Windows {
        Windows9x() {
        }

        boolean supportsEnvironmentVariables() {
            return false;
        }

        Hashtable getEnvironmentVariables() {
            return new Hashtable();
        }

        void setUpDefaultAliases(Hashtable hashtable) {
            String[] stringArray = new String[]{"md", "rd", "del", "dir", "copy", "move", "erase", "mkdir", "rmdir", "start", "echo", "path", "ver", "vol", "ren", "type"};
            for (int i = 0; i < stringArray.length; ++i) {
                hashtable.put(stringArray[i], "command.com /c " + stringArray[i]);
            }
        }

        Process exec(String[] stringArray, String[] stringArray2, String string) throws Exception {
            String string2 = stringArray[0];
            String[] stringArray3 = string2.indexOf(46) == -1 ? this.getExtensionsToTry() : new String[]{""};
            for (int i = 0; i < stringArray3.length; ++i) {
                stringArray[0] = string2 + stringArray3[i];
                try {
                    return Runtime.getRuntime().exec(stringArray, null, new File(string));
                }
                catch (Exception exception) {
                    if (i != stringArray3.length - 1) continue;
                    throw new Exception(jEdit.getProperty((String)"console.shell.not-found-win", (Object[])new String[]{string2}));
                }
            }
            return null;
        }

        String[] getExtensionsToTry() {
            return new String[]{".exe", ".com"};
        }
    }

    static abstract class Windows
    extends ProcessRunner {
        Windows() {
        }

        boolean shellExpandsGlobs() {
            return false;
        }

        boolean isCaseSensitive() {
            return false;
        }
    }

    static class Unix
    extends ProcessRunner {
        Unix() {
        }

        boolean shellExpandsGlobs() {
            return true;
        }

        boolean supportsEnvironmentVariables() {
            return true;
        }

        Hashtable getEnvironmentVariables() {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            try {
                String string;
                Process process = Runtime.getRuntime().exec("env");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string = bufferedReader.readLine()) != null) {
                    Log.log((int)1, (Object)this, (Object)string);
                    int n = string.indexOf(61);
                    if (n == -1) continue;
                    hashtable.put(string.substring(0, n), string.substring(n + 1));
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Log.log((int)9, (Object)this, (Object)iOException);
            }
            return hashtable;
        }

        boolean isCaseSensitive() {
            return true;
        }
    }

    static class Generic
    extends ProcessRunner {
        Generic() {
        }

        boolean shellExpandsGlobs() {
            return true;
        }

        boolean supportsEnvironmentVariables() {
            return false;
        }

        Hashtable getEnvironmentVariables() {
            return new Hashtable();
        }

        boolean isCaseSensitive() {
            return true;
        }
    }
}

