/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.Output;
import java.util.ArrayList;
import java.util.Vector;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.jEdit;

public abstract class Shell {
    public static final String SERVICE = "console.Shell";
    private static Vector shells = new Vector();
    private String name;

    public static void registerShell(Shell shell) {
        shells.addElement(shell);
    }

    public static void unregisterShell(Shell shell) {
        shells.removeElement(shell);
    }

    public static String[] getShellNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < shells.size(); ++i) {
            arrayList.add(((Shell)shells.get(i)).getName());
        }
        String[] stringArray = ServiceManager.getServiceNames((String)SERVICE);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Shell getShell(String string) {
        for (int i = 0; i < shells.size(); ++i) {
            Shell shell = (Shell)shells.get(i);
            if (!shell.getName().equals(string)) continue;
            return shell;
        }
        return (Shell)ServiceManager.getService((String)SERVICE, (String)string);
    }

    public Shell(String string) {
        this.name = string;
    }

    public abstract void printInfoMessage(Output var1);

    public void printPrompt(Console console, Output output) {
        output.print(console.getInfoColor(), jEdit.getProperty((String)"console.prompt", (Object[])new String[]{this.getName()}));
    }

    public void execute(Console console, String string, Output output, Output output2, String string2) {
        this.execute(console, output, string2);
    }

    public void execute(Console console, Output output, String string) {
    }

    public abstract void stop(Console var1);

    public abstract boolean waitFor(Console var1);

    public CompletionInfo getCompletions(Console console, String string) {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static class CompletionInfo {
        public int offset;
        public String[] completions;
    }
}

