/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.ConsolePlugin;
import console.ConsoleProcess;
import console.Output;
import console.ProcessRunner;
import console.Shell;
import console.SystemShellBuiltIn;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.jEdit;

public class SystemShell
extends Shell {
    private static Hashtable consoleStateMap = new Hashtable();
    private final char dosSlash = (char)127;
    private Hashtable aliases;
    private Hashtable variables;
    private Hashtable commands;
    private boolean initialized;

    public SystemShell() {
        super("System");
    }

    public void printInfoMessage(Output output) {
        output.print(null, jEdit.getProperty((String)"console.shell.info"));
    }

    public void printPrompt(Console console, Output output) {
        String string = SystemShell.getConsoleState(console) == null ? System.getProperty("user.dir") : SystemShell.getConsoleState((Console)console).currentDirectory;
        output.print(console.getInfoColor(), jEdit.getProperty((String)"console.shell.prompt", (Object[])new String[]{string}));
    }

    public void execute(Console console, String string, Output output, Output output2, String string2) {
        if (string2.startsWith("#")) {
            output.commandDone();
            output2.commandDone();
            return;
        }
        ConsoleState consoleState = SystemShell.getConsoleState(console);
        String string3 = consoleState.currentDirectory;
        if (!new File(string3).exists()) {
            output2.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.error.working-dir", (Object[])new String[]{string3}));
            output.commandDone();
            output2.commandDone();
            return;
        }
        this.init();
        Vector vector = this.parse(string2);
        if (vector == null) {
            output.commandDone();
            output2.commandDone();
            return;
        }
        vector = this.preprocess(console.getView(), console, vector);
        String string4 = (String)vector.elementAt(0);
        if (string4.charAt(0) == '%') {
            vector.removeElementAt(0);
            this.executeBuiltIn(console, output, output2, string4, vector);
            output.commandDone();
            output2.commandDone();
        } else {
            String string5 = MiscUtilities.constructPath((String)string3, (String)string4);
            if (string4.startsWith("./") || string4.startsWith("." + File.separator)) {
                vector.setElementAt(string5, 0);
            }
            if (new File(string5).isDirectory() && vector.size() == 1) {
                vector.setElementAt(string5, 0);
                this.executeBuiltIn(console, output, output2, "%cd", vector);
                output.commandDone();
                output2.commandDone();
            } else {
                String[] stringArray;
                boolean bl;
                if (vector.elementAt(vector.size() - 1).equals("&")) {
                    vector.removeElementAt(vector.size() - 1);
                    bl = false;
                    output.commandDone();
                    output2.commandDone();
                } else {
                    bl = true;
                }
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                if (ProcessRunner.getProcessRunner().supportsEnvironmentVariables()) {
                    stringArray = new String[this.variables.size()];
                    int n = 0;
                    Enumeration enumeration = this.variables.keys();
                    while (enumeration.hasMoreElements()) {
                        Object k = enumeration.nextElement();
                        stringArray[n++] = k + "=" + this.variables.get(k);
                    }
                } else {
                    stringArray = null;
                }
                new ConsoleProcess(console, string, output, output2, (String[])objectArray, stringArray, bl);
            }
        }
    }

    public void stop(Console console) {
        ConsoleState consoleState = SystemShell.getConsoleState(console);
        ConsoleProcess consoleProcess = consoleState.process;
        if (consoleProcess != null) {
            consoleProcess.stop();
        } else {
            console.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.noproc"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(Console console) {
        ConsoleState consoleState = SystemShell.getConsoleState(console);
        ConsoleProcess consoleProcess = consoleState.process;
        if (consoleProcess != null) {
            try {
                ConsoleProcess consoleProcess2 = consoleProcess;
                synchronized (consoleProcess2) {
                    consoleProcess.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return consoleProcess.getExitStatus();
        }
        return true;
    }

    public Shell.CompletionInfo getCompletions(Console console, String string) {
        int n;
        String string2;
        String string3;
        this.init();
        View view = console.getView();
        String string4 = console == null ? System.getProperty("user.dir") : SystemShell.getConsoleState((Console)console).currentDirectory;
        String string5 = "='\" \\" + File.pathSeparator;
        if (File.separatorChar == '\\') {
            string2 = string3 = (String)this.parse(string).lastElement();
        } else {
            string3 = SystemShell.findLastArgument(string, string5);
            string2 = SystemShell.unescape(string3, string5);
        }
        Shell.CompletionInfo completionInfo = new Shell.CompletionInfo();
        completionInfo.offset = string.length() - string2.length();
        completionInfo.completions = completionInfo.offset == 0 ? this.getCommandCompletions(view, string4, string2).toArray(new String[0]) : this.getFileCompletions(view, string4, string2, false).toArray(new String[0]);
        if (File.separatorChar != '\\') {
            for (n = 0; n < completionInfo.completions.length; ++n) {
                completionInfo.completions[n] = SystemShell.escape(completionInfo.completions[n], string5);
            }
        }
        int n2 = n = completionInfo.offset > 0 && string.charAt(completionInfo.offset - 1) == '\"' ? 1 : 0;
        if (n == 0) {
            String string6 = File.separatorChar == '\\' ? " " : string5;
            for (int i = 0; i < completionInfo.completions.length; ++i) {
                String string7 = completionInfo.completions[i];
                if (SystemShell.containsCharacters(string7, string6)) {
                    string7 = "\"" + string7;
                }
                completionInfo.completions[i] = string7;
            }
        }
        return completionInfo;
    }

    public String expandVariables(View view, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\u007f': {
                    stringBuffer.append('\\');
                    continue block6;
                }
                case '%': {
                    String string2;
                    int n = string.indexOf(37, i + 1);
                    if (n != -1) {
                        if (n == i + 1) continue block6;
                        string2 = string.substring(i + 1, n);
                        i = n;
                        String string3 = this.getVariableValue(view, string2);
                        if (string3 == null) continue block6;
                        stringBuffer.append(string3);
                        continue block6;
                    }
                    stringBuffer.append('%');
                    continue block6;
                }
                case '$': {
                    String string2;
                    int n;
                    if (i == string.length() - 1) {
                        stringBuffer.append(c);
                        continue block6;
                    }
                    if (string.charAt(i + 1) == '{') {
                        n = string.indexOf(125, i + 1);
                        if (n == -1) {
                            n = string.length();
                        }
                        string2 = string.substring(i + 2, n);
                        i = n;
                    } else {
                        char c2;
                        for (n = i + 1; n < string.length() && (Character.isLetterOrDigit(c2 = string.charAt(n)) || c2 == '_' || c2 == '$'); ++n) {
                        }
                        string2 = string.substring(i + 1, n);
                        i = n - 1;
                        if (string2.startsWith("$")) {
                            stringBuffer.append(string2);
                            continue block6;
                        }
                        if (string2.length() == 0) continue block6;
                    }
                    String string4 = this.getVariableValue(view, string2);
                    if (string4 == null) continue block6;
                    stringBuffer.append(string4);
                    continue block6;
                }
                case '~': {
                    String string5 = System.getProperty("user.home");
                    if (string.length() == 1) {
                        stringBuffer.append(string5);
                        continue block6;
                    }
                    boolean bl = true;
                    if (i != 0 && (c = string.charAt(i - 1)) != '=') {
                        bl = false;
                    }
                    if (i != string.length() - 1 && (c = string.charAt(i + 1)) != '/' && c != File.separatorChar) {
                        bl = false;
                    }
                    if (bl) {
                        stringBuffer.append(string5);
                        continue block6;
                    }
                    stringBuffer.append('~');
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String getVariableValue(View view, String string) {
        Object object;
        this.init();
        if (view == null) {
            return (String)this.variables.get(string);
        }
        Buffer buffer = view.getBuffer();
        if (string.equals("$") || string.equals("%")) {
            object = string;
        } else if (string.equals("d")) {
            object = MiscUtilities.getParentOfPath((String)buffer.getPath());
            if (((String)object).endsWith("/") || ((String)object).endsWith(File.separator)) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
        } else if (string.equals("u")) {
            object = buffer.getPath();
            if (!MiscUtilities.isURL((String)object)) {
                object = "file:/" + ((String)object).replace(File.separatorChar, '/');
            }
        } else if (string.equals("f")) {
            object = buffer.getPath();
        } else if (string.equals("n")) {
            object = buffer.getName();
        } else if (string.equals("c")) {
            object = ConsolePlugin.getClassName(buffer);
        } else if (string.equals("PKG")) {
            object = ConsolePlugin.getPackageName(buffer);
            if (object == null) {
                object = "";
            }
        } else {
            VFSBrowser vFSBrowser;
            object = string.equals("ROOT") ? ConsolePlugin.getPackageRoot(buffer) : (string.equals("BROWSER_DIR") ? ((vFSBrowser = (VFSBrowser)view.getDockableWindowManager().getDockable("vfs.browser")) == null ? null : vFSBrowser.getDirectory()) : (String)this.variables.get(string));
        }
        return object;
    }

    public Hashtable getAliases() {
        this.init();
        return this.aliases;
    }

    static void consoleOpened(Console console) {
        consoleStateMap.put(console, new ConsoleState());
    }

    static void consoleClosed(Console console) {
        ConsoleProcess consoleProcess = SystemShell.getConsoleState((Console)console).process;
        if (consoleProcess != null) {
            consoleProcess.stop();
        }
        consoleStateMap.remove(console);
    }

    static ConsoleState getConsoleState(Console console) {
        return (ConsoleState)consoleStateMap.get(console);
    }

    Hashtable getVariables() {
        this.init();
        return this.variables;
    }

    static void propertiesChanged() {
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.initCommands();
        this.initAliases();
        this.initVariables();
    }

    private void initCommands() {
        this.commands = new Hashtable();
        this.commands.put("%alias", new SystemShellBuiltIn.alias());
        this.commands.put("%aliases", new SystemShellBuiltIn.aliases());
        this.commands.put("%browse", new SystemShellBuiltIn.browse());
        this.commands.put("%cd", new SystemShellBuiltIn.cd());
        this.commands.put("%clear", new SystemShellBuiltIn.clear());
        this.commands.put("%dirstack", new SystemShellBuiltIn.dirstack());
        this.commands.put("%detach", new SystemShellBuiltIn.detach());
        this.commands.put("%echo", new SystemShellBuiltIn.echo());
        this.commands.put("%edit", new SystemShellBuiltIn.edit());
        this.commands.put("%env", new SystemShellBuiltIn.env());
        this.commands.put("%help", new SystemShellBuiltIn.help());
        this.commands.put("%kill", new SystemShellBuiltIn.kill());
        this.commands.put("%popd", new SystemShellBuiltIn.popd());
        this.commands.put("%pushd", new SystemShellBuiltIn.pushd());
        this.commands.put("%pwd", new SystemShellBuiltIn.pwd());
        this.commands.put("%run", new SystemShellBuiltIn.run());
        this.commands.put("%set", new SystemShellBuiltIn.set());
        this.commands.put("%unalias", new SystemShellBuiltIn.unalias());
        this.commands.put("%unset", new SystemShellBuiltIn.unset());
        this.commands.put("%version", new SystemShellBuiltIn.version());
    }

    private void initAliases() {
        this.aliases = new Hashtable();
        this.aliases.put("cd", "%cd");
        this.aliases.put("pwd", "%pwd");
        this.aliases.put("-", "%cd -");
    }

    private void initVariables() {
        ProcessRunner processRunner = ProcessRunner.getProcessRunner();
        processRunner.setUpDefaultAliases(this.aliases);
        this.variables = processRunner.getEnvironmentVariables();
        if (jEdit.getJEditHome() != null) {
            this.variables.put("JEDIT_HOME", jEdit.getJEditHome());
        }
        if (jEdit.getSettingsDirectory() != null) {
            this.variables.put("JEDIT_SETTINGS", jEdit.getSettingsDirectory());
        }
        this.variables.put("TERM", "dumb");
    }

    private Vector parse(String string) {
        Vector<String> vector;
        block10: {
            vector = new Vector<String>();
            if (File.separatorChar == '\\') {
                string = string.replace('\\', '\u007f');
            }
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(33, 255);
            streamTokenizer.whitespaceChars(0, 32);
            streamTokenizer.quoteChar(34);
            streamTokenizer.quoteChar(39);
            try {
                while (true) {
                    switch (streamTokenizer.nextToken()) {
                        case -1: {
                            break block10;
                        }
                        case -3: 
                        case 34: 
                        case 39: {
                            if (File.separatorChar == '\\') {
                                vector.addElement(streamTokenizer.sval.replace('\u007f', '\\'));
                                break;
                            }
                            vector.addElement(streamTokenizer.sval);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    private Vector preprocess(View view, Console console, Vector vector) {
        Vector vector2 = new Vector();
        String string = (String)vector.elementAt(0);
        String string2 = (String)this.aliases.get(string);
        if (string2 != null) {
            Vector vector3 = this.parse(string2);
            for (int i = 0; i < vector3.size(); ++i) {
                this.expandGlobs(view, vector2, (String)vector3.elementAt(i));
            }
        } else {
            this.expandGlobs(view, vector2, string);
        }
        for (int i = 1; i < vector.size(); ++i) {
            this.expandGlobs(view, vector2, (String)vector.elementAt(i));
        }
        return vector2;
    }

    private void expandGlobs(View view, Vector vector, String string) {
        vector.addElement(this.expandVariables(view, string));
    }

    public void executeBuiltIn(Console console, Output output, Output output2, String string, Vector vector) {
        SystemShellBuiltIn systemShellBuiltIn = (SystemShellBuiltIn)this.commands.get(string);
        if (systemShellBuiltIn == null) {
            Object[] objectArray = new String[]{string};
            output2.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.unknown-builtin", (Object[])objectArray));
        } else {
            systemShellBuiltIn.execute(console, output, output2, vector);
        }
    }

    private List getFileCompletions(View view, String string, String string2, boolean bl) {
        String string3 = this.expandVariables(view, string2);
        int n = string3.lastIndexOf(File.separator);
        String string4 = n == -1 ? "" : string3.substring(0, n + 1);
        File file = new File(string3).isAbsolute() ? new File(string3) : new File(string, string3);
        boolean bl2 = string3.endsWith(File.separator) || string3.length() == 0;
        File file2 = bl2 ? file : file.getParentFile();
        String string5 = bl2 ? "" : file.getName();
        String[] stringArray = file2.list();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        boolean bl3 = ProcessRunner.getProcessRunner().isCaseSensitive();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        boolean bl4 = false;
        String string6 = bl3 ? string5 : string5.toLowerCase();
        for (int i = 0; i < stringArray.length; ++i) {
            String string7;
            String string8 = string7 = bl3 ? stringArray[i] : stringArray[i].toLowerCase();
            if (!string7.startsWith(string6)) continue;
            File file3 = new File(file2, stringArray[i]);
            if (bl && !file3.isDirectory()) continue;
            String string9 = string4 + stringArray[i];
            if (file3.isDirectory() && !string9.endsWith(File.separator)) {
                string9 = string9 + File.separator;
            }
            arrayList.add(string9);
        }
        return arrayList;
    }

    private List getCommandCompletions(View view, String string, String string2) {
        String string3;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.commands.keySet().iterator();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            if (!string3.startsWith(string2)) continue;
            arrayList.add(string3);
        }
        iterator = this.aliases.keySet().iterator();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            if (!string3.startsWith(string2)) continue;
            arrayList.add(string3);
        }
        arrayList.addAll(this.getFileCompletions(view, string, string2, false));
        return arrayList;
    }

    private static String findLastArgument(String string, String string2) {
        int n;
        for (n = string.length() - 1; n >= 0; --n) {
            char c = string.charAt(n);
            if (string2.indexOf(c) == -1) continue;
            if (n == 0 || string.charAt(n - 1) != '\\') break;
            --n;
        }
        return string.substring(n + 1);
    }

    private static String unescape(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            if (string2.indexOf(c) == -1 || string.charAt(i - 1) != '\\') continue;
            --i;
        }
        return stringBuffer.reverse().toString();
    }

    private static String escape(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) != -1) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static boolean containsCharacters(String string, String string2) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string2.indexOf(string.charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    static class ConsoleState {
        String currentDirectory = System.getProperty("user.dir");
        String lastDirectory = System.getProperty("user.dir");
        Stack directoryStack = new Stack();
        ConsoleProcess process;

        ConsoleState() {
        }

        void gotoLastDirectory(Console console) {
            Object[] objectArray = new String[]{this.lastDirectory};
            if (new File(this.lastDirectory).exists()) {
                String string = this.currentDirectory;
                this.currentDirectory = this.lastDirectory;
                this.lastDirectory = string;
                console.print(console.getInfoColor(), jEdit.getProperty((String)"console.shell.cd.ok", (Object[])objectArray));
            } else {
                console.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.cd.error", (Object[])objectArray));
            }
        }

        void setCurrentDirectory(Console console, String string) {
            Object[] objectArray = new String[]{string};
            if (new File(string).exists()) {
                this.lastDirectory = this.currentDirectory;
                this.currentDirectory = string;
            } else {
                console.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.cd.error", (Object[])objectArray));
            }
        }
    }
}

