/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.ConsolePlugin;
import console.ConsoleProcess;
import console.Output;
import console.SystemShell;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.help.HelpViewer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public abstract class SystemShellBuiltIn {
    protected String name = this.name.substring(this.name.lastIndexOf(36) + 1);
    protected String help = jEdit.getProperty((String)("console.shell." + this.name + ".usage"));

    public SystemShellBuiltIn() {
        if (this.help == null) {
            Log.log((int)7, (Object)this, (Object)(this.name + " is missing usage info"));
        }
    }

    public Option[] getOptions() {
        return new Option[0];
    }

    public int getMinArguments() {
        return 0;
    }

    public int getMaxArguments() {
        return -1;
    }

    public void execute(Console console, Output output, Output output2, Vector vector) {
        int n;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Option[] optionArray = this.getOptions();
        for (n = 0; n < vector.size(); ++n) {
            int n2;
            String string = (String)vector.elementAt(n);
            if (string.equals("--")) {
                vector.removeElementAt(n);
                break;
            }
            if (string.equals("--help")) {
                output2.print(null, this.help);
                return;
            }
            if (string.startsWith("--")) {
                if (string.length() == 2) continue;
                vector.removeElementAt(n);
                --n;
                String string2 = string.substring(2);
                if (string2.startsWith("no-")) {
                    n2 = 1;
                    string2 = string2.substring(3);
                } else {
                    n2 = 0;
                }
                Option option = null;
                for (int i = 0; i < optionArray.length; ++i) {
                    if (!optionArray[i].longName.equals(string2)) continue;
                    option = optionArray[i];
                    break;
                }
                if (option == null) {
                    Object[] objectArray = new String[]{string2};
                    output2.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.bad-opt-long", (Object[])objectArray));
                    return;
                }
                if (option.takesArgument) {
                    if (n2 != 0) {
                        Object[] objectArray = new String[]{string2};
                        output2.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.no-arg-long", (Object[])objectArray));
                        return;
                    }
                    if (n == vector.size() - 1) {
                        Object[] objectArray = new String[]{string2};
                        output2.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.need-arg-long", (Object[])objectArray));
                        return;
                    }
                    hashtable.put(string2, vector.elementAt(n + 1));
                    vector.removeElementAt(n + 1);
                    continue;
                }
                if (n2 != 0) {
                    hashtable.put(string2, Boolean.FALSE);
                    continue;
                }
                hashtable.put(string2, Boolean.TRUE);
                continue;
            }
            if (!string.startsWith("-") && !string.startsWith("+") || string.length() == 1) continue;
            vector.removeElementAt(n);
            --n;
            boolean bl = string.charAt(0) == '+';
            for (n2 = 1; n2 < string.length(); ++n2) {
                char c = string.charAt(n2);
                Option option = null;
                for (int i = 0; i < optionArray.length; ++i) {
                    if (optionArray[i].shortName != c) continue;
                    option = optionArray[i];
                    break;
                }
                if (option == null) {
                    Object[] objectArray = new String[]{String.valueOf(c)};
                    output2.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.bad-opt", (Object[])objectArray));
                    return;
                }
                if (bl) {
                    hashtable.put(option.longName, Boolean.FALSE);
                    continue;
                }
                hashtable.put(option.longName, Boolean.TRUE);
            }
        }
        n = this.getMinArguments();
        int n3 = this.getMaxArguments();
        if (vector.size() < this.getMinArguments() || n3 != -1 && vector.size() > this.getMaxArguments()) {
            output2.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.bad-args"));
            return;
        }
        this.execute(console, output, output2, vector, hashtable);
    }

    protected abstract void execute(Console var1, Output var2, Output var3, Vector var4, Hashtable var5);

    static class version
    extends SystemShellBuiltIn {
        version() {
        }

        public int getMinArguments() {
            return 0;
        }

        public int getMaxArguments() {
            return 0;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            output.print(null, jEdit.getProperty((String)"plugin.console.ConsolePlugin.version"));
        }
    }

    static class unset
    extends SystemShellBuiltIn {
        unset() {
        }

        public int getMinArguments() {
            return 1;
        }

        public int getMaxArguments() {
            return 1;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            Hashtable hashtable2 = ConsolePlugin.getSystemShell().getVariables();
            hashtable2.remove(vector.elementAt(0));
        }
    }

    static class unalias
    extends SystemShellBuiltIn {
        unalias() {
        }

        public int getMinArguments() {
            return 1;
        }

        public int getMaxArguments() {
            return 1;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            Hashtable hashtable2 = ConsolePlugin.getSystemShell().getAliases();
            hashtable2.remove(vector.elementAt(0));
        }
    }

    static class set
    extends SystemShellBuiltIn {
        set() {
        }

        public int getMinArguments() {
            return 2;
        }

        public int getMaxArguments() {
            return 2;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            Hashtable hashtable2 = ConsolePlugin.getSystemShell().getVariables();
            hashtable2.put(vector.elementAt(0), vector.elementAt(1));
        }
    }

    static class run
    extends SystemShellBuiltIn {
        run() {
        }

        public int getMinArguments() {
            return 1;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            String string = SystemShell.getConsoleState((Console)console).currentDirectory;
            for (int i = 0; i < vector.size(); ++i) {
                Macros.runScript((View)console.getView(), (String)MiscUtilities.constructPath((String)string, (String)((String)vector.get(i))), (boolean)false);
            }
        }
    }

    static class pwd
    extends SystemShellBuiltIn {
        pwd() {
        }

        public int getMinArguments() {
            return 0;
        }

        public int getMaxArguments() {
            return 0;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
        }
    }

    static class pushd
    extends SystemShellBuiltIn {
        pushd() {
        }

        public int getMaxArguments() {
            return 0;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            SystemShell.ConsoleState consoleState = SystemShell.getConsoleState(console);
            Stack stack = consoleState.directoryStack;
            stack.push(consoleState.currentDirectory);
            Object[] objectArray = new String[]{consoleState.currentDirectory};
            output2.print(null, jEdit.getProperty((String)"console.shell.pushd.ok", (Object[])objectArray));
        }
    }

    static class popd
    extends SystemShellBuiltIn {
        popd() {
        }

        public int getMaxArguments() {
            return 0;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            SystemShell.ConsoleState consoleState = SystemShell.getConsoleState(console);
            Stack stack = consoleState.directoryStack;
            if (stack.isEmpty()) {
                output2.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.popd.error"));
                return;
            }
            String string = (String)stack.pop();
            consoleState.setCurrentDirectory(console, string);
        }
    }

    static class kill
    extends SystemShellBuiltIn {
        kill() {
        }

        public int getMaxArguments() {
            return 1;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            SystemShell.ConsoleState consoleState = SystemShell.getConsoleState(console);
            ConsoleProcess consoleProcess = consoleState.process;
            if (consoleProcess == null) {
                output2.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.noproc"));
                return;
            }
            consoleProcess.stop();
        }
    }

    static class help
    extends SystemShellBuiltIn {
        static String HELP_PATH = "jeditresource:/Console.jar!/index.html";

        help() {
        }

        public int getMinArguments() {
            return 0;
        }

        public int getMaxArguments() {
            return 1;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            if (vector.size() == 1) {
                String string;
                String string2 = (String)vector.get(0);
                if (string2.startsWith("%")) {
                    string2 = string2.substring(1);
                }
                if ((string = jEdit.getProperty((String)("console.shell." + string2 + ".usage"))) != null) {
                    output2.print(null, string);
                } else {
                    new HelpViewer(string2);
                }
            } else {
                new HelpViewer(HELP_PATH);
            }
        }
    }

    static class env
    extends SystemShellBuiltIn {
        env() {
        }

        public int getMinArguments() {
            return 0;
        }

        public int getMaxArguments() {
            return 0;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            Hashtable hashtable2 = ConsolePlugin.getSystemShell().getVariables();
            Vector<String> vector2 = new Vector<String>();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                vector2.addElement(k + "=" + hashtable2.get(k));
            }
            MiscUtilities.quicksort(vector2, (MiscUtilities.Compare)new MiscUtilities.StringICaseCompare());
            for (int i = 0; i < vector2.size(); ++i) {
                output.print(null, (String)vector2.elementAt(i));
            }
        }
    }

    static class edit
    extends SystemShellBuiltIn {
        edit() {
        }

        public int getMinArguments() {
            return 1;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            String string = SystemShell.getConsoleState((Console)console).currentDirectory;
            for (int i = 0; i < vector.size(); ++i) {
                jEdit.openFile((View)console.getView(), (String)string, (String)((String)vector.elementAt(i)), (boolean)false, null);
            }
        }
    }

    static class echo
    extends SystemShellBuiltIn {
        echo() {
        }

        public int getMinArguments() {
            return 1;
        }

        public int getMaxArguments() {
            return -1;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            for (int i = 0; i < vector.size(); ++i) {
                output.print(null, (String)vector.elementAt(i));
            }
        }
    }

    static class dirstack
    extends SystemShellBuiltIn {
        dirstack() {
        }

        public int getMaxArguments() {
            return 0;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            Stack stack = SystemShell.getConsoleState((Console)console).directoryStack;
            for (int i = 0; i < stack.size(); ++i) {
                output.print(null, (String)stack.elementAt(i));
            }
        }
    }

    static class detach
    extends SystemShellBuiltIn {
        detach() {
        }

        public int getMaxArguments() {
            return 1;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            SystemShell.ConsoleState consoleState = SystemShell.getConsoleState(console);
            ConsoleProcess consoleProcess = consoleState.process;
            if (consoleProcess == null) {
                output2.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.noproc"));
                return;
            }
            consoleProcess.detach();
        }
    }

    static class clear
    extends SystemShellBuiltIn {
        clear() {
        }

        public int getMinArguments() {
            return 0;
        }

        public int getMaxArguments() {
            return 0;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            console.clear();
        }
    }

    static class cd
    extends SystemShellBuiltIn {
        cd() {
        }

        public int getMaxArguments() {
            return 1;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            SystemShell.ConsoleState consoleState = SystemShell.getConsoleState(console);
            if (vector.size() == 0) {
                consoleState.setCurrentDirectory(console, System.getProperty("user.home"));
            } else {
                String string = (String)vector.elementAt(0);
                if (string.equals("-")) {
                    consoleState.gotoLastDirectory(console);
                } else {
                    consoleState.setCurrentDirectory(console, MiscUtilities.constructPath((String)consoleState.currentDirectory, (String)((String)vector.elementAt(0))));
                }
            }
        }
    }

    static class browse
    extends SystemShellBuiltIn {
        browse() {
        }

        public int getMaxArguments() {
            return 1;
        }

        public Option[] getOptions() {
            return new Option[]{new Option('n', "new-window", false)};
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            String string;
            String string2 = SystemShell.getConsoleState((Console)console).currentDirectory;
            String string3 = string = vector.size() == 0 ? string2 : MiscUtilities.constructPath((String)string2, (String)((String)vector.elementAt(0)));
            if (hashtable.get("new-window") != null) {
                VFSBrowser.browseDirectoryInNewWindow((View)console.getView(), (String)string);
            } else {
                VFSBrowser.browseDirectory((View)console.getView(), (String)string);
            }
        }
    }

    static class aliases
    extends SystemShellBuiltIn {
        aliases() {
        }

        public int getMinArguments() {
            return 0;
        }

        public int getMaxArguments() {
            return 0;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            Hashtable hashtable2 = ConsolePlugin.getSystemShell().getAliases();
            Vector<String> vector2 = new Vector<String>();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                vector2.addElement(k + "=" + hashtable2.get(k));
            }
            MiscUtilities.quicksort(vector2, (MiscUtilities.Compare)new MiscUtilities.StringICaseCompare());
            for (int i = 0; i < vector2.size(); ++i) {
                output.print(null, (String)vector2.elementAt(i));
            }
        }
    }

    static class alias
    extends SystemShellBuiltIn {
        alias() {
        }

        public int getMinArguments() {
            return 2;
        }

        public int getMaxArguments() {
            return 2;
        }

        public void execute(Console console, Output output, Output output2, Vector vector, Hashtable hashtable) {
            Hashtable hashtable2 = ConsolePlugin.getSystemShell().getAliases();
            hashtable2.put(vector.elementAt(0), vector.elementAt(1));
        }
    }

    public class Option {
        public char shortName;
        public String longName;
        public boolean takesArgument;

        public Option(char c, String string, boolean bl) {
            this.shortName = c;
            this.longName = string;
            this.takesArgument = bl;
        }
    }
}

