/*
 * Decompiled with CFR 0.152.
 */
package console.commando;

import bsh.EvalError;
import bsh.NameSpace;
import bsh.This;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlHandler;
import com.microstar.xml.XmlParser;
import console.Console;
import console.ConsolePlugin;
import console.commando.CommandoCommand;
import console.commando.CommandoHandler;
import console.commando.CommandoThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class CommandoDialog
extends EnhancedDialog {
    private View view;
    private JComboBox commandCombo;
    private JTabbedPane tabs;
    private SettingsPane settings;
    private TextAreaPane commandLine;
    private JButton ok;
    private JButton cancel;
    private CommandoCommand command;
    private NameSpace nameSpace;
    private List scripts;
    private List components;
    private boolean init;

    public CommandoDialog(View view, String string) {
        super((Frame)view, jEdit.getProperty((String)"commando.title"), false);
        this.view = view;
        JPanel jPanel = new JPanel(new BorderLayout(0, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(jEdit.getProperty((String)"commando.caption"));
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 12));
        jPanel2.add("West", jLabel);
        jPanel.add("North", jPanel2);
        EditAction[] editActionArray = ConsolePlugin.getCommandoCommands();
        ActionHandler actionHandler = new ActionHandler();
        this.commandCombo = new JComboBox<EditAction>(editActionArray);
        this.commandCombo.setRenderer(new Renderer());
        this.commandCombo.addActionListener(actionHandler);
        jPanel2.add("Center", this.commandCombo);
        this.tabs = new JTabbedPane();
        this.settings = new SettingsPane();
        this.tabs.addTab(jEdit.getProperty((String)"commando.settings"), this.settings);
        this.commandLine = new TextAreaPane();
        this.tabs.addTab(jEdit.getProperty((String)"commando.commands"), this.commandLine);
        this.tabs.addChangeListener(new ChangeHandler());
        if (string == null) {
            string = jEdit.getProperty((String)"commando.last-command");
        }
        for (int i = 0; i < editActionArray.length; ++i) {
            if (!editActionArray[i].getName().equals(string)) continue;
            this.commandCombo.setSelectedIndex(i);
            break;
        }
        this.load((CommandoCommand)((Object)this.commandCombo.getSelectedItem()));
        jPanel.add("Center", this.tabs);
        Box box = new Box(0);
        box.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty((String)"common.ok"));
        this.ok.addActionListener(actionHandler);
        this.getRootPane().setDefaultButton(this.ok);
        box.add(this.ok);
        box.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty((String)"common.cancel"));
        this.cancel.addActionListener(actionHandler);
        box.add(this.cancel);
        box.add(Box.createGlue());
        jPanel.add("South", box);
        this.pack();
        this.setLocationRelativeTo((Component)view);
        this.show();
    }

    public void ok() {
        Object object;
        this.updateNameSpace();
        jEdit.setProperty((String)"commando.last-command", (String)this.command.getName());
        Vector<CommandoHandler.Command> vector = new Vector<CommandoHandler.Command>();
        for (int i = 0; i < this.scripts.size(); ++i) {
            object = (CommandoHandler.Script)this.scripts.get(i);
            CommandoHandler.Command command = ((CommandoHandler.Script)object).getCommand();
            if (command == null) {
                return;
            }
            vector.addElement(command);
        }
        DockableWindowManager dockableWindowManager = this.view.getDockableWindowManager();
        dockableWindowManager.addDockableWindow("console");
        object = new CommandoThread((Console)dockableWindowManager.getDockable("console"), vector);
        ((Thread)object).start();
        this.dispose();
    }

    public void cancel() {
        jEdit.setProperty((String)"commando.last-command", (String)this.command.getName());
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void load(CommandoCommand commandoCommand) {
        block17: {
            this.init = true;
            this.command = commandoCommand;
            this.settings.removeAll();
            this.components = new ArrayList();
            this.commandLine.setText(null);
            this.nameSpace = new NameSpace(BeanShell.getNameSpace(), "commando");
            this.scripts = new ArrayList();
            XmlParser xmlParser = new XmlParser();
            CommandoHandler commandoHandler = new CommandoHandler(this.view, commandoCommand, this.settings, this.nameSpace, this.components, this.scripts);
            xmlParser.setHandler((XmlHandler)commandoHandler);
            Reader reader = null;
            reader = commandoCommand.openStream();
            xmlParser.parse(null, null, reader);
            Object var10_5 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                break block17;
            }
            catch (IOException iOException) {
                Log.log((int)9, (Object)((Object)this), (Object)iOException);
            }
            break block17;
            {
                catch (XmlException xmlException) {
                    Log.log((int)9, (Object)((Object)this), (Object)((Object)xmlException));
                    int n = xmlException.getLine();
                    String string = xmlException.getMessage();
                    Object[] objectArray = new Object[]{commandoCommand.getLabel() + ".xml", new Integer(n), string};
                    GUIUtilities.error(null, (String)"commando.xml-error", (Object[])objectArray);
                    Object var10_6 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block17;
                    }
                    catch (IOException iOException) {
                        Log.log((int)9, (Object)((Object)this), (Object)iOException);
                    }
                    break block17;
                }
                catch (IOException iOException) {
                    Log.log((int)9, (Object)((Object)this), (Object)iOException);
                    Object[] objectArray = new Object[]{commandoCommand.getLabel() + ".xml", iOException.toString()};
                    GUIUtilities.error(null, (String)"read-error", (Object[])objectArray);
                    Object var10_7 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block17;
                    }
                    catch (IOException iOException2) {
                        Log.log((int)9, (Object)((Object)this), (Object)iOException2);
                    }
                    break block17;
                }
                catch (Exception exception) {
                    Log.log((int)9, (Object)((Object)this), (Object)exception);
                    Object var10_8 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block17;
                    }
                    catch (IOException iOException) {
                        Log.log((int)9, (Object)((Object)this), (Object)iOException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    Log.log((int)9, (Object)((Object)this), (Object)iOException);
                }
                throw throwable;
            }
        }
        this.getRootPane().revalidate();
        this.pack();
        this.init = false;
        this.tabs.setSelectedIndex(0);
    }

    private void updateNameSpace() {
        for (int i = 0; i < this.components.size(); ++i) {
            This this_ = (This)this.components.get(i);
            try {
                this_.invokeMethod("valueChanged", new Object[0]);
                continue;
            }
            catch (EvalError evalError) {
                Log.log((int)9, (Object)((Object)this), (Object)((Object)evalError));
            }
        }
    }

    private void updateTextArea() {
        if (this.init) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.scripts.size(); ++i) {
            CommandoHandler.Script script = (CommandoHandler.Script)this.scripts.get(i);
            CommandoHandler.Command command = script.getCommand();
            if (command == null) {
                return;
            }
            stringBuffer.append(command.shell);
            stringBuffer.append(": ");
            stringBuffer.append(command.command);
            stringBuffer.append('\n');
        }
        this.commandLine.setText(stringBuffer.toString());
    }

    static class TextAreaPane
    extends JPanel {
        private JButton copy;
        private JTextArea textArea;

        TextAreaPane() {
            super(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(6, 0, 6, 0));
            this.copy = new JButton(jEdit.getProperty((String)"commando.copy"));
            jPanel.add("West", this.copy);
            this.copy.addActionListener(new ActionHandler());
            this.add("North", jPanel);
            this.textArea = new JTextArea(4, 30);
            this.add("Center", new JScrollPane(this.textArea));
            this.textArea.setEditable(false);
            this.textArea.setLineWrap(true);
        }

        void setText(String string) {
            this.textArea.setText(string);
        }

        class ActionHandler
        implements ActionListener {
            ActionHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                TextAreaPane.this.textArea.copy();
            }
        }
    }

    public static class SettingsPane
    extends JPanel {
        private GridBagLayout gridBag = new GridBagLayout();
        private int y;

        SettingsPane() {
            this.setLayout(this.gridBag);
        }

        public void addComponent(String string, Component component) {
            JLabel jLabel = new JLabel(string + ":");
            jLabel.setBorder(new EmptyBorder(0, 0, 0, 12));
            this.addComponent(jLabel, component);
        }

        public void addComponent(Component component, Component component2) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.y++;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 1;
            this.gridBag.setConstraints(component, gridBagConstraints);
            this.add(component);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            this.gridBag.setConstraints(component2, gridBagConstraints);
            this.add(component2);
        }

        public void addComponent(Component component) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.y++;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            this.gridBag.setConstraints(component, gridBagConstraints);
            this.add(component);
        }
    }

    class ChangeHandler
    implements ChangeListener {
        ChangeHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (CommandoDialog.this.tabs.getSelectedIndex() == 1) {
                CommandoDialog.this.updateNameSpace();
                CommandoDialog.this.updateTextArea();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == CommandoDialog.this.commandCombo) {
                CommandoCommand commandoCommand = (CommandoCommand)((Object)CommandoDialog.this.commandCombo.getSelectedItem());
                CommandoDialog.this.load(commandoCommand);
            } else if (actionEvent.getSource() == CommandoDialog.this.ok) {
                CommandoDialog.this.ok();
            } else if (actionEvent.getSource() == CommandoDialog.this.cancel) {
                CommandoDialog.this.cancel();
            }
        }
    }

    class Renderer
    extends DefaultListCellRenderer {
        Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            EditAction editAction = (EditAction)object;
            this.setText(editAction.getLabel());
            return this;
        }
    }
}

