/*
 * Decompiled with CFR 0.152.
 */
package console.commando;

import console.ConsolePlugin;
import console.commando.CommandoDialog;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;

public class CommandoToolBar
extends JToolBar
implements EBComponent {
    private View view;

    public CommandoToolBar(View view) {
        this.setLayout(new BoxLayout(this, 0));
        this.setFloatable(false);
        this.view = view;
        this.updateButtons();
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((EBComponent)this);
    }

    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus((EBComponent)this);
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof DynamicMenuChanged && "plugin.console.ConsolePlugin.menu".equals(((DynamicMenuChanged)eBMessage).getMenuName())) {
            this.updateButtons();
        }
    }

    private void updateButtons() {
        this.removeAll();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new CommandoDialog(CommandoToolBar.this.view, actionEvent.getActionCommand());
            }
        };
        EditAction[] editActionArray = ConsolePlugin.getCommandoCommands();
        for (int i = 0; i < editActionArray.length; ++i) {
            EditAction editAction = editActionArray[i];
            JButton jButton = new JButton(editAction.getLabel());
            jButton.setActionCommand(editAction.getName());
            jButton.addActionListener(actionListener);
            jButton.setRequestFocusEnabled(false);
            jButton.setMargin(new Insets(1, 2, 1, 2));
            this.add(jButton);
        }
        this.add(Box.createGlue());
    }
}

