/*
 * Decompiled with CFR 0.152.
 */
package console.options;

import console.ConsolePlugin;
import console.ErrorMatcher;
import console.options.ErrorMatcherDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;

public class ErrorsOptionPane
extends AbstractOptionPane {
    private JList errorList;
    private DefaultListModel errorListModel;
    private JButton edit;
    private JButton add;
    private JButton remove;

    public ErrorsOptionPane() {
        super("console.errors");
    }

    protected void _init() {
        this.addComponent(new JLabel(jEdit.getProperty((String)"options.console.errors.caption")));
        this.addComponent(Box.createVerticalStrut(6));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.errorListModel = this.createMatcherListModel();
        this.errorList = new JList(this.errorListModel);
        jPanel.add("Center", new JScrollPane(this.errorList));
        this.errorList.setSelectionMode(0);
        this.errorList.addListSelectionListener(new ListHandler());
        this.errorList.addMouseListener(new MouseHandler());
        this.errorList.setVisibleRowCount(5);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(6, 0, 0, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createGlue());
        this.add = new JButton(jEdit.getProperty((String)"options.console.errors.add"));
        jPanel2.add(this.add);
        this.add.addActionListener(new ActionHandler());
        jPanel2.add(Box.createHorizontalStrut(6));
        this.edit = new JButton(jEdit.getProperty((String)"options.console.errors.edit"));
        jPanel2.add(this.edit);
        this.edit.addActionListener(new ActionHandler());
        jPanel2.add(Box.createHorizontalStrut(6));
        this.remove = new JButton(jEdit.getProperty((String)"options.console.errors.remove"));
        jPanel2.add(this.remove);
        this.remove.addActionListener(new ActionHandler());
        jPanel2.add(Box.createHorizontalStrut(6));
        jPanel2.add(Box.createGlue());
        jPanel.add("South", jPanel2);
        this.updateButtons();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.y++;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.gridBag.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
    }

    protected void _save() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.errorListModel.getSize(); ++i) {
            ErrorMatcher errorMatcher = (ErrorMatcher)this.errorListModel.getElementAt(i);
            errorMatcher.save();
            if (!errorMatcher.user) continue;
            if (i != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(errorMatcher.internalName);
        }
        jEdit.setProperty((String)"console.error.user", (String)stringBuffer.toString());
    }

    private DefaultListModel createMatcherListModel() {
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        ErrorMatcher[] errorMatcherArray = ConsolePlugin.getErrorMatchers();
        for (int i = 0; i < errorMatcherArray.length; ++i) {
            defaultListModel.addElement(errorMatcherArray[i].clone());
        }
        return defaultListModel;
    }

    private void updateButtons() {
        int n = this.errorList.getSelectedIndex();
        if (n == -1) {
            this.edit.setEnabled(false);
            this.remove.setEnabled(false);
        } else {
            this.edit.setEnabled(true);
            ErrorMatcher errorMatcher = (ErrorMatcher)this.errorList.getSelectedValue();
            this.remove.setEnabled(errorMatcher.user);
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                ErrorMatcher errorMatcher = (ErrorMatcher)ErrorsOptionPane.this.errorList.getSelectedValue();
                new ErrorMatcherDialog((Component)((Object)ErrorsOptionPane.this), errorMatcher);
                ErrorsOptionPane.this.errorList.repaint();
            }
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ErrorsOptionPane.this.updateButtons();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ErrorsOptionPane.this.edit) {
                ErrorMatcher errorMatcher = (ErrorMatcher)ErrorsOptionPane.this.errorList.getSelectedValue();
                new ErrorMatcherDialog((Component)((Object)ErrorsOptionPane.this), errorMatcher);
                ErrorsOptionPane.this.errorList.repaint();
            } else if (object == ErrorsOptionPane.this.add) {
                ErrorMatcher errorMatcher = new ErrorMatcher();
                errorMatcher.user = true;
                if (new ErrorMatcherDialog((Component)((Object)ErrorsOptionPane.this), errorMatcher).isOK()) {
                    int n = ErrorsOptionPane.this.errorList.getSelectedIndex() + 1;
                    ErrorsOptionPane.this.errorListModel.insertElementAt(errorMatcher, n);
                    ErrorsOptionPane.this.errorList.setSelectedIndex(n);
                }
            } else if (object == ErrorsOptionPane.this.remove) {
                ErrorsOptionPane.this.errorListModel.removeElementAt(ErrorsOptionPane.this.errorList.getSelectedIndex());
                ErrorsOptionPane.this.updateButtons();
            }
        }
    }
}

