/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InputDialog
extends JDialog {
    public static final double MIN_WIDTH = 290.0;
    public static final double MIN_HEIGHT = 110.0;
    ActionListener al = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            InputDialog.this.selected = InputDialog.this.centPanel.getValue();
            InputDialog.this.setVisible(false);
            InputDialog.this.dispose();
        }
    };
    private JLabel label;
    private JButton okJB;
    private JPanel panel;
    private CentrePanel centPanel;
    String selected;
    private Window parent;

    public InputDialog(Frame owner, String key, String message, String defValue) {
        super(owner, "Please input a value for " + key, true);
        this.parent = owner;
        this.init(key, message, defValue);
    }

    public InputDialog(Frame owner, String key, String message, String defValue, String[] opts, boolean allowUser) {
        super(owner, "Please input a value for " + key, true);
        this.parent = owner;
        this.init(key, message, defValue, opts, allowUser);
    }

    public InputDialog(Dialog owner, String key, String message, String defValue) {
        super(owner, "Please input a value for " + key, true);
        this.parent = owner;
        this.init(key, message, defValue);
    }

    public InputDialog(Dialog owner, String key, String message, String defValue, String[] opts, boolean allowUser) {
        super(owner, "Please input a value for " + key, true);
        this.parent = owner;
        this.init(key, message, defValue, opts, allowUser);
    }

    public String getValue() {
        return this.selected;
    }

    public String showDialog() {
        this.pack();
        this.setLocationRelativeTo(this.parent);
        this.show();
        return this.getValue();
    }

    public Dimension getMinimumSize() {
        Dimension supMin = super.getMinimumSize();
        return new Dimension((int)Math.max(supMin.getWidth(), 290.0), (int)Math.max(supMin.getHeight(), 110.0));
    }

    public Dimension getPreferredSize() {
        Dimension supMin = super.getPreferredSize();
        return new Dimension((int)Math.max(supMin.getWidth(), 290.0), (int)Math.max(supMin.getHeight(), 110.0));
    }

    private void init(String key, String message, String defValue, String[] opts, boolean allowUser) {
        this.centPanel = new CentrePanel();
        this.centPanel.addComboBox(opts, defValue, allowUser);
        this.init(message);
    }

    private void init(String key, String message, String defValue) {
        this.centPanel = new CentrePanel();
        this.centPanel.addTextBox(defValue);
        this.init(message);
    }

    private void init(String message) {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                InputDialog.this.okJB.doClick();
            }
        });
        this.setResizable(false);
        this.panel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.panel.setLayout(gb);
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridy = 0;
        this.label = new JLabel(message);
        this.label.setHorizontalAlignment(2);
        gb.setConstraints(this.label, c);
        this.panel.add(this.label);
        c.gridy = 1;
        gb.setConstraints(this.centPanel, c);
        this.panel.add(this.centPanel);
        c.gridy = 2;
        c.fill = 0;
        c.anchor = 14;
        this.okJB = new JButton("OK");
        this.getRootPane().setDefaultButton(this.okJB);
        this.okJB.addActionListener(this.al);
        gb.setConstraints(this.okJB, c);
        this.panel.add(this.okJB);
        this.setContentPane(this.panel);
    }

    private class CentrePanel
    extends JPanel {
        private JTextField text;
        private JComboBox box;

        public CentrePanel() {
            this.setLayout(new BorderLayout());
        }

        public void addTextBox(String defValue) {
            this.box = null;
            this.text = new JTextField(defValue, 20);
            this.add((Component)this.text, "Center");
            if (defValue != null) {
                this.text.setSelectionStart(0);
                this.text.setSelectionEnd(defValue.length());
            }
            this.text.addActionListener(InputDialog.this.al);
        }

        public void addComboBox(String[] opts, String defValue, boolean editable) {
            this.text = null;
            this.box = new JComboBox<String>(opts);
            this.add(this.box);
            if (defValue != null) {
                boolean defValInc = false;
                for (int i = 0; i < opts.length; ++i) {
                    if (!opts[i].equals(defValue)) continue;
                    this.box.setSelectedIndex(i);
                    defValInc = true;
                }
                if (!defValInc) {
                    this.box.addItem(defValue);
                    this.box.setSelectedItem(defValue);
                }
            }
            this.box.setEditable(editable);
            this.box.addActionListener(new ActionListener(this){
                private final /* synthetic */ CentrePanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    if (!CentrePanel.access$200(this.this$1).isPopupVisible()) {
                        InputDialog.access$000(CentrePanel.access$300(this.this$1)).doClick();
                    }
                }
            });
        }

        public String getValue() {
            if (this.box == null) {
                return this.text.getText();
            }
            return (String)this.box.getSelectedItem();
        }

        static /* synthetic */ JComboBox access$200(CentrePanel x0) {
            return x0.box;
        }

        static /* synthetic */ InputDialog access$300(CentrePanel x0) {
            return x0.InputDialog.this;
        }
    }
}

