/*
 * Decompiled with CFR 0.152.
 */
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class InsertTextCommand
implements Command {
    private String text;
    private int charPos = -1;

    public static void insertText(String text, ScriptContext sc) {
        InsertTextCommand co = new InsertTextCommand(text);
        co.run(sc);
    }

    public InsertTextCommand(String text) {
        this.text = text;
    }

    public void run(ScriptContext sc) {
        View v = sc.getView();
        Buffer b = v.getBuffer();
        JEditTextArea textArea = v.getTextArea();
        String t = MiscUtilities.escapesToChars((String)this.text);
        StringBuffer buf = new StringBuffer(t.length());
        String selected = textArea.getSelectedText() != null ? textArea.getSelectedText() : "";
        for (int i = 0; i < t.length(); ++i) {
            char c = t.charAt(i);
            if (c == '|') {
                if (i < t.length() - 1 && t.charAt(i + 1) == '|') {
                    ++i;
                    buf.append(c);
                    continue;
                }
                buf.append(selected);
                this.charPos = i;
                continue;
            }
            buf.append(c);
        }
        int pos = textArea.getCaretPosition();
        b.insert(pos, buf.toString());
        if (this.charPos != -1) {
            sc.getCommandQueue().addLast(new SetCursorPositionCommand(pos + this.charPos));
        }
        textArea.setCaretPosition(pos + buf.length());
    }
}

