/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Vector;
import javax.swing.ImageIcon;

public class Utilities {
    public static final int OPEN = 0;
    public static final int SAVE = 1;
    static /* synthetic */ Class class$Utilities;

    public static ImageIcon getIcon(String picture) {
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage((class$Utilities == null ? (class$Utilities = Utilities.class$("Utilities")) : class$Utilities).getResource(picture)));
    }

    public static String getUserDirectory() {
        return System.getProperty("user.dir");
    }

    public static String[] getWildCardMatches(String s, boolean sort) {
        return Utilities.getWildCardMatches(null, s, sort);
    }

    public static String[] getWildCardMatches(String path, String s, boolean sort) {
        String args = new String(s.trim());
        Vector<String> filesThatMatchVector = new Vector<String>();
        String[] files = path == null ? new File(Utilities.getUserDirectory()).list() : new File(path).list();
        for (int i = 0; i < files.length; ++i) {
            if (!Utilities.match(args, files[i])) continue;
            File temp = new File(Utilities.getUserDirectory(), files[i]);
            filesThatMatchVector.addElement(new String(temp.getName()));
        }
        Object[] filesThatMatch = new String[filesThatMatchVector.size()];
        filesThatMatchVector.copyInto(filesThatMatch);
        if (sort) {
            Utilities.sortStrings((String[])filesThatMatch);
        }
        return filesThatMatch;
    }

    public static boolean match(String pattern, String string) {
        int p = 0;
        while (true) {
            int s = 0;
            while (true) {
                boolean pEnd;
                boolean sEnd = s >= string.length();
                boolean bl = pEnd = p >= pattern.length() || pattern.charAt(p) == '|';
                if (sEnd && pEnd) {
                    return true;
                }
                if (sEnd || pEnd) break;
                if (pattern.charAt(p) != '?') {
                    if (pattern.charAt(p) == '*') {
                        ++p;
                        for (int i = string.length(); i >= s; --i) {
                            if (!Utilities.match(pattern.substring(p), string.substring(i))) continue;
                            return true;
                        }
                        break;
                    }
                    if (pattern.charAt(p) != string.charAt(s)) break;
                }
                ++p;
                ++s;
            }
            if ((p = pattern.indexOf(124, p)) == -1) {
                return false;
            }
            ++p;
        }
    }

    public static void sortStrings(String[] strings) {
        Utilities.sortStrings(strings, 0, strings.length - 1);
    }

    public static void sortStrings(String[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            String mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a[lo].compareTo(mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && a[hi].compareTo(mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                Utilities.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                Utilities.sortStrings(a, lo0, hi);
            }
            if (lo < hi0) {
                Utilities.sortStrings(a, lo, hi0);
            }
        }
    }

    public static void swap(String[] a, int i, int j) {
        String T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    public static boolean checkIfTrue(String input, boolean defVal) {
        if (input == null) {
            return defVal;
        }
        if (input.equalsIgnoreCase("true") || input.equalsIgnoreCase("yes") || input.equalsIgnoreCase("1") || input.equalsIgnoreCase("on")) {
            return true;
        }
        if (input.equalsIgnoreCase("false") || input.equalsIgnoreCase("no") || input.equalsIgnoreCase("0") || input.equalsIgnoreCase("off")) {
            return false;
        }
        return defVal;
    }

    public static String replace(String input, String oldPart, String newPart) {
        int len = oldPart.length();
        int newLen = newPart.length();
        int start = 0;
        while ((start = input.indexOf(oldPart, start)) != -1) {
            input = input.substring(0, start) + newPart + input.substring(start + len);
            start += newLen;
        }
        return input;
    }

    public static String[] findStrings(String input) {
        int quot1 = 34;
        int quot2 = 39;
        Vector<String> v = new Vector<String>(10);
        StreamTokenizer sT = new StreamTokenizer(new StringReader(input));
        sT.quoteChar(quot1);
        sT.quoteChar(quot2);
        try {
            while (true) {
                int i = sT.nextToken();
                if (i != -1) {
                    if (i != -3 && i != quot1 && i != quot2) continue;
                    v.add(sT.sval);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Object[] strings = new String[v.size()];
        v.copyInto(strings);
        return strings;
    }

    public static String trimStart(String input) {
        int str;
        char[] val = input.toCharArray();
        for (str = 0; str < input.length() && val[str] <= ' '; ++str) {
        }
        return str > 0 ? input.substring(str) : input;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

