/*
 * Decompiled with CFR 0.152.
 */
import com.microstar.xml.HandlerBase;
import java.util.Stack;
import org.gjt.sp.util.Log;

public class XInsertHandler
extends HandlerBase {
    private XTree tree;
    private Stack stateStack;
    private int type = 0;
    private String lastAttr;
    private String lastName;
    private String lastValue;
    private String lastAttrValue;
    private String propValue;

    public XInsertHandler(XTree tree) {
        this.tree = tree;
    }

    public void attribute(String aname, String value, boolean isSpecified) {
        if (aname.equalsIgnoreCase("TYPE")) {
            if (value.equalsIgnoreCase("MACRO")) {
                this.type = 1;
            } else if (value.equalsIgnoreCase("XINSERT_SCRIPT")) {
                this.type = 2;
            } else if (value.equalsIgnoreCase("TEXT")) {
                this.type = 0;
            } else if (value.equalsIgnoreCase("NAMED_MACRO")) {
                this.type = 3;
            } else {
                this.type = -1;
                Log.log((int)7, (Object)((Object)this), (Object)("Invalid value for attribute \"type\": " + value));
            }
        } else if (aname.equalsIgnoreCase("NAME")) {
            this.lastAttr = aname;
            this.lastAttrValue = value;
        } else if (aname.equalsIgnoreCase("VALUE")) {
            this.propValue = value;
        }
    }

    public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
        if (!"XINSERT".equalsIgnoreCase(name)) {
            throw new Exception("Not a valid XInsert file !");
        }
    }

    public void charData(char[] c, int off, int len) {
        if ("ITEM".equalsIgnoreCase((String)this.stateStack.peek())) {
            this.lastValue = new String(c, off, len);
        }
    }

    public void startElement(String name) {
        if ("NAME".equalsIgnoreCase(this.lastAttr)) {
            if ("MENU".equalsIgnoreCase(name)) {
                this.tree.addMenu(this.lastAttrValue);
            }
            if ("VARIABLE".equalsIgnoreCase(name)) {
                if (this.propValue == null || this.lastAttrValue == null) {
                    Log.log((int)7, (Object)((Object)this), (Object)"Can not set XInsert property");
                } else {
                    this.tree.addVariable(this.lastAttrValue, this.propValue);
                }
            }
        }
        this.stateStack.push(name);
    }

    public void endElement(String name) {
        if (name == null) {
            return;
        }
        String lastStartTag = (String)this.stateStack.peek();
        if (name.equalsIgnoreCase(lastStartTag)) {
            if (lastStartTag.equalsIgnoreCase("MENU")) {
                this.tree.closeMenu();
            } else if (lastStartTag.equalsIgnoreCase("ITEM")) {
                this.tree.addInsert(this.lastAttrValue, this.lastValue, this.type);
                this.type = 0;
            }
            this.stateStack.pop();
        } else {
            System.err.println("Unclosed tag: " + this.stateStack.peek());
        }
        this.lastAttr = null;
        this.lastAttrValue = null;
    }

    public void startDocument() {
        try {
            this.stateStack = new Stack();
            this.stateStack.push(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

