/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class XInsertOptionPane
extends AbstractOptionPane
implements ActionListener {
    private JTable varsTable;
    private JButton pickDirectory;
    private JTextField directoryText;
    private JCheckBox displayDefaults;
    private InsertCheckBox[] insertCheckBoxes;
    private VariablesModel vmodel;
    static /* synthetic */ Class class$java$lang$String;

    public XInsertOptionPane() {
        super("xinsert");
    }

    public void _init() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel dispOpt = new JPanel(new BorderLayout());
        dispOpt.setBorder(new EmptyBorder(0, 25, 0, 0));
        Box left = Box.createVerticalBox();
        Box right = Box.createVerticalBox();
        this.initInserts(left, right);
        Box options = Box.createHorizontalBox();
        left.add(Box.createGlue());
        right.add(Box.createGlue());
        options.add(left);
        options.add(right);
        dispOpt.add((Component)options, "Center");
        this.displayDefaults = new JCheckBox(jEdit.getProperty((String)"options.xinsert.display.defaults"));
        this.displayDefaults.addActionListener(this);
        JPanel dispDef = new JPanel(new BorderLayout());
        dispDef.setOpaque(false);
        dispDef.setBorder(new TitledBorder(new EtchedBorder(), jEdit.getProperty((String)"options.xinsert.display.title")));
        dispDef.add((Component)this.displayDefaults, "North");
        dispDef.add((Component)dispOpt, "Center");
        JPanel outerFilePanel = new JPanel(new BorderLayout());
        JPanel filePanel = new JPanel(new BorderLayout());
        filePanel.setOpaque(false);
        filePanel.setBorder(new TitledBorder(new EtchedBorder(), jEdit.getProperty((String)"options.xinsert.inserts-directory")));
        this.directoryText = new JTextField();
        filePanel.add((Component)this.directoryText, "Center");
        this.pickDirectory = new JButton(jEdit.getProperty((String)"options.xinsert.choose-directory"));
        this.pickDirectory.addActionListener(this);
        this.directoryText.setText(jEdit.getProperty((String)"xinsert.inserts-directory"));
        filePanel.add((Component)this.pickDirectory, "East");
        outerFilePanel.add((Component)filePanel, "North");
        JPanel varPanel = new JPanel(new BorderLayout());
        varPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        varPanel.add((Component)new JLabel("Global Variables:"), "North");
        this.vmodel = new VariablesModel();
        this.varsTable = new JTable(this.vmodel);
        this.varsTable.getTableHeader().setReorderingAllowed(false);
        Dimension d = this.varsTable.getPreferredSize();
        d.height = Math.min(d.height, 100);
        JScrollPane scroller = new JScrollPane(this.varsTable);
        scroller.setPreferredSize(d);
        varPanel.add((Component)scroller, "Center");
        outerFilePanel.add((Component)varPanel, "Center");
        this.add(dispDef, "North");
        this.add(outerFilePanel, "Center");
        this.displayDefaults.setSelected(jEdit.getBooleanProperty((String)"xinsert.display.all", (boolean)true));
        this.displaySettings();
    }

    public void initInserts(Box left, Box right) {
        String current;
        Vector<String> ins = new Vector<String>(10);
        int i = 0;
        while ((current = jEdit.getProperty((String)("xinsert.inserts." + i))) != null) {
            ins.add(current);
            ++i;
        }
        ins.add(jEdit.getProperty((String)"xinsert.inserts.macros"));
        this.insertCheckBoxes = new InsertCheckBox[ins.size()];
        for (int j = 0; j < this.insertCheckBoxes.length; ++j) {
            this.insertCheckBoxes[j] = new InsertCheckBox((String)ins.get(j));
            if (j % 2 == 0) {
                left.add(this.insertCheckBoxes[j]);
                continue;
            }
            right.add(this.insertCheckBoxes[j]);
        }
    }

    private void displaySettings() {
        if (this.displayDefaults.isSelected()) {
            for (int i = 0; i < this.insertCheckBoxes.length; ++i) {
                this.insertCheckBoxes[i].setEnabled(true);
            }
        } else {
            for (int i = 0; i < this.insertCheckBoxes.length; ++i) {
                this.insertCheckBoxes[i].setEnabled(false);
            }
        }
    }

    public void _save() {
        jEdit.setBooleanProperty((String)"xinsert.display.all", (boolean)this.displayDefaults.isSelected());
        for (int i = 0; i < this.insertCheckBoxes.length; ++i) {
            this.insertCheckBoxes[i].saveState();
        }
        Log.log((int)1, (Object)this, (Object)("XInsert directory set to" + this.directoryText.getText()));
        jEdit.setProperty((String)"xinsert.inserts-directory", (String)this.directoryText.getText());
        XInsertPlugin.clearVariables();
        Iterator vis = this.vmodel.vars.iterator();
        while (vis.hasNext()) {
            VariablesModel.VarItem vi = (VariablesModel.VarItem)vis.next();
            if (vi.name == null || vi.name == "") continue;
            XInsertPlugin.setVariable(vi.name, vi.value == null ? "" : vi.value);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.pickDirectory) {
            File file;
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            int retVal = chooser.showDialog((Component)((Object)this), jEdit.getProperty((String)"options.xinsert.choose-directory"));
            if (retVal == 0 && (file = chooser.getSelectedFile()) != null) {
                try {
                    String dirName = file.getCanonicalPath();
                    this.directoryText.setText(dirName);
                }
                catch (IOException e) {}
            }
        } else if (evt.getSource() == this.displayDefaults) {
            this.displaySettings();
        } else {
            Log.log((int)9, (Object)this, (Object)"Action Event Not Defined");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InsertCheckBox
    extends JCheckBox {
        private String insert;

        private InsertCheckBox(String insert) {
            this.insert = insert;
            this.setText(jEdit.getProperty((String)("options.xinsert.display." + insert), (String)"Unknown!"));
            this.setSelected(jEdit.getBooleanProperty((String)("xinsert.display." + insert), (boolean)true));
        }

        private void saveState() {
            jEdit.setBooleanProperty((String)("xinsert.display." + this.insert), (boolean)this.isSelected());
        }
    }

    class VariablesModel
    extends AbstractTableModel {
        Vector vars = new Vector(XInsertPlugin.getVariablesSize());

        public VariablesModel() {
            Enumeration en = XInsertPlugin.getVariables();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                this.vars.add(new VarItem(name, XInsertPlugin.getVariable(name)));
            }
        }

        public Class getColumnClass(int index) {
            return class$java$lang$String == null ? (class$java$lang$String = XInsertOptionPane.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.vars.size() + 1;
        }

        public Object getValueAt(int row, int column) {
            if (row == this.vars.size()) {
                return "";
            }
            VarItem vi = (VarItem)this.vars.elementAt(row);
            if (column == 0) {
                return vi.name;
            }
            return vi.value;
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            if (row == this.vars.size()) {
                String name = col == 0 ? (String)value : null;
                String _value = col == 1 ? (String)value : null;
                this.vars.addElement(new VarItem(name, _value));
                this.fireTableRowsUpdated(row, row + 1);
            } else {
                VarItem vi = (VarItem)this.vars.elementAt(row);
                switch (col) {
                    case 0: {
                        vi.name = (String)value;
                        break;
                    }
                    case 1: {
                        vi.value = (String)value;
                    }
                }
                this.fireTableRowsUpdated(row, row);
            }
        }

        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Value";
                }
            }
            return null;
        }

        class VarItem {
            String name;
            String value;

            VarItem() {
            }

            VarItem(String name, String value) {
                this.name = name;
                this.value = value;
            }
        }
    }
}

