/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.OptionsDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class XInsertPlugin
extends EBPlugin {
    public static final String NAME = "XInsert";
    private static Properties variables;
    static /* synthetic */ Class class$org$gjt$sp$jedit$jEdit;
    static /* synthetic */ Class class$XInsertPlugin;

    public String getName() {
        return NAME;
    }

    public void start() {
        String sep = System.getProperty("file.separator");
        if (jEdit.getProperty((String)"xinsert.inserts-directory") == null || jEdit.getProperty((String)"xinsert.inserts-directory").equals("")) {
            String defDir = jEdit.getSettingsDirectory() + sep + "xinsert" + sep;
            jEdit.setProperty((String)"xinsert.inserts-directory", (String)defDir);
            Log.log((int)3, (Object)((Object)this), (Object)("XInsert Inserts Directory set to: " + defDir));
        }
        variables = new Properties();
        try {
            InputStream is = (class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = XInsertPlugin.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit).getResourceAsStream("net.sourceforge.jedit.xinsert.variables");
            if (is != null) {
                XInsertPlugin.loadVariables(is);
            }
        }
        catch (IOException e) {
            Log.log((int)9, (Object)(class$XInsertPlugin == null ? (class$XInsertPlugin = XInsertPlugin.class$("XInsertPlugin")) : class$XInsertPlugin), (Object)"Error loading system variables");
            Log.log((int)9, (Object)(class$XInsertPlugin == null ? (class$XInsertPlugin = XInsertPlugin.class$("XInsertPlugin")) : class$XInsertPlugin), (Object)e);
        }
        try {
            File glVars = new File(MiscUtilities.constructPath((String)jEdit.getSettingsDirectory(), (String)("xinsert" + sep + "variables")));
            if (glVars.exists() && glVars.isFile()) {
                BufferedInputStream buf = new BufferedInputStream(new FileInputStream(glVars));
                XInsertPlugin.loadVariables(buf);
            }
        }
        catch (IOException e) {
            Log.log((int)9, (Object)(class$XInsertPlugin == null ? (class$XInsertPlugin = XInsertPlugin.class$("XInsertPlugin")) : class$XInsertPlugin), (Object)"Error loading user defined global variables");
            Log.log((int)9, (Object)(class$XInsertPlugin == null ? (class$XInsertPlugin = XInsertPlugin.class$("XInsertPlugin")) : class$XInsertPlugin), (Object)e);
        }
    }

    public void createMenuItems(Vector menuItems) {
        menuItems.addElement(GUIUtilities.loadMenuItem((String)"XInsert.toggle"));
    }

    public void createOptionPanes(OptionsDialog optD) {
        optD.addOptionPane((OptionPane)new XInsertOptionPane());
    }

    public void stop() {
        try {
            File gldir = new File(jEdit.getSettingsDirectory(), "xinsert");
            gldir.mkdirs();
            File glVars = new File(gldir, "variables");
            glVars.createNewFile();
            BufferedOutputStream buf = new BufferedOutputStream(new FileOutputStream(glVars));
            XInsertPlugin.saveVariables(buf);
        }
        catch (IOException e) {
            Log.log((int)9, (Object)(class$XInsertPlugin == null ? (class$XInsertPlugin = XInsertPlugin.class$("XInsertPlugin")) : class$XInsertPlugin), (Object)"Error saving user defined global variables");
            Log.log((int)9, (Object)(class$XInsertPlugin == null ? (class$XInsertPlugin = XInsertPlugin.class$("XInsertPlugin")) : class$XInsertPlugin), (Object)e);
        }
    }

    public static void setVariable(String name, String value) {
        variables.put(name, value);
    }

    public static String getVariable(String name) {
        return (String)variables.get(name);
    }

    public static Enumeration getVariables() {
        return variables.propertyNames();
    }

    public static int getVariablesSize() {
        return variables.size();
    }

    public static String getViewSpecificVariable(View view, String key) {
        Buffer buffer = view.getBuffer();
        if (key.equals("path")) {
            return Utilities.replace(buffer.getPath(), "\\", "\\\\");
        }
        if (key.equals("name")) {
            return Utilities.replace(buffer.getName(), "\\", "\\\\");
        }
        if (key.equals("filename")) {
            String path = buffer.getPath();
            if (path != null) {
                return new File(path).getName();
            }
        } else if (key.equals("directory")) {
            File path = new File(buffer.getPath());
            if (path != null) {
                return Utilities.replace(path.getParent(), "\\", "\\\\");
            }
        } else {
            if (key.equals("date")) {
                DateFormat df = DateFormat.getDateInstance(1);
                return df.format(new Date(System.currentTimeMillis()));
            }
            if (key.equals("time")) {
                DateFormat df = DateFormat.getTimeInstance(1);
                return df.format(new Date(System.currentTimeMillis()));
            }
            if (key.equals("datetime")) {
                DateFormat df = DateFormat.getDateTimeInstance(1, 1);
                return df.format(new Date(System.currentTimeMillis()));
            }
            if (key.equals("selected")) {
                return view.getTextArea().getSelectedText();
            }
        }
        return null;
    }

    public static boolean containsVariable(String name) {
        return variables.containsKey(name);
    }

    public static void loadVariables(InputStream in) throws IOException {
        variables.load(in);
    }

    public static void saveVariables(OutputStream out) {
        try {
            variables.store(out, "XInsert Global Variables File");
        }
        catch (IOException e) {
            Log.log((int)9, (Object)(class$XInsertPlugin == null ? (class$XInsertPlugin = XInsertPlugin.class$("XInsertPlugin")) : class$XInsertPlugin), (Object)"Failure to write XInsert variables to disk.");
            Log.log((int)9, (Object)(class$XInsertPlugin == null ? (class$XInsertPlugin = XInsertPlugin.class$("XInsertPlugin")) : class$XInsertPlugin), (Object)e);
        }
    }

    public static void clearVariables() {
        variables.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

