/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;

public class XTree
extends JPanel
implements TreeSelectionListener,
ActionListener {
    private XTreeTree tree;
    private View parent;
    private static Vector inserts;
    private DefaultTreeModel treeModel;
    private JButton expand;
    private JButton collapse;
    private JButton reload;
    private JCheckBox carriageReturn;
    private JCheckBox executeScript;
    private boolean treeJustCollapsed = false;
    private int rootIndex;
    private XTreeNode root;
    private Stack menuStack = null;
    private XTreeObject xtreeObj = null;
    private int lineNo;
    private static final ImageIcon plainLeaf;
    private static final ImageIcon scriptLeaf;
    private static final ImageIcon macroLeaf;
    private static final ImageIcon namedmacroLeaf;
    private static final ImageIcon errorLeaf;
    static /* synthetic */ Class class$XTree;

    public void addMenu(String nodeName) {
        this.xtreeObj = new XTreeObject(new XTreeNode(nodeName), 0);
        if (this.menuStack.empty()) {
            this.treeModel.insertNodeInto(this.xtreeObj.getXTreeNode(), this.root, this.rootIndex);
            ++this.rootIndex;
        } else {
            XTreeObject obj = (XTreeObject)this.menuStack.peek();
            this.treeModel.insertNodeInto(this.xtreeObj.getXTreeNode(), obj.getXTreeNode(), obj.getIndex());
            obj.incrementIndex();
        }
        this.menuStack.push(this.xtreeObj);
    }

    public void closeMenu() {
        try {
            this.xtreeObj = (XTreeObject)this.menuStack.pop();
        }
        catch (Exception e) {
            this.xtreeObj = null;
        }
    }

    public void addVariable(String key, String value) {
        XTreeObject obj = (XTreeObject)this.menuStack.peek();
        XTreeNode node = obj != null ? obj.getXTreeNode() : this.root;
        node.addVariable(key, value);
    }

    public void addInsert(String nodeName, String content, int script) {
        inserts.addElement(new XTreeItem(content, script));
        XTreeNode node = new XTreeNode(nodeName, inserts.size());
        if (this.xtreeObj == null) {
            this.treeModel.insertNodeInto(node, this.root, this.rootIndex);
            ++this.rootIndex;
        } else {
            XTreeObject obj = (XTreeObject)this.menuStack.peek();
            this.treeModel.insertNodeInto(node, obj.getXTreeNode(), obj.getIndex());
            obj.incrementIndex();
        }
    }

    public XTree(View parent) {
        this.parent = parent;
        this.setLayout(new BorderLayout());
        this.root = new XTreeNode("XInsert");
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new XTreeTree(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.addTreeSelectionListener(this);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setCellRenderer(new XTreeCellRenderer());
        this.init();
        JPanel pane = new JPanel(new BorderLayout());
        this.collapse = new JButton(Utilities.getIcon("images/button_collapse.gif"));
        pane.add((Component)this.collapse, "West");
        this.collapse.setToolTipText(jEdit.getProperty((String)"xtree.collapse.button"));
        this.collapse.addActionListener(this);
        this.reload = new JButton(Utilities.getIcon("images/menu_reload.gif"));
        pane.add((Component)this.reload, "Center");
        this.reload.setToolTipText(jEdit.getProperty((String)"xtree.reload.button"));
        this.reload.addActionListener(this);
        this.expand = new JButton(Utilities.getIcon("images/button_expand.gif"));
        pane.add((Component)this.expand, "East");
        this.expand.setToolTipText(jEdit.getProperty((String)"xtree.expand.button"));
        this.expand.addActionListener(this);
        this.add((Component)pane, "North");
        this.add((Component)new JScrollPane(this.tree), "Center");
        JPanel optionPane = new JPanel(new BorderLayout());
        this.carriageReturn = new JCheckBox(jEdit.getProperty((String)"xtree.carriage.label"));
        optionPane.add((Component)this.carriageReturn, "North");
        this.carriageReturn.setSelected(jEdit.getBooleanProperty((String)"xtree.carriage", (boolean)false));
        this.carriageReturn.addActionListener(this);
        this.executeScript = new JCheckBox(jEdit.getProperty((String)"xtree.execute.label"));
        optionPane.add((Component)this.executeScript, "Center");
        this.executeScript.setSelected(jEdit.getBooleanProperty((String)"xtree.execute", (boolean)true));
        if (jEdit.getProperty((String)"xtree.execute") == null) {
            this.executeScript.setSelected(true);
        }
        this.executeScript.addActionListener(this);
        this.add((Component)optionPane, "South");
    }

    private void init() {
        inserts = new Vector(200);
        this.menuStack = new Stack();
        this.rootIndex = 0;
        if (jEdit.getBooleanProperty((String)"xinsert.display.all", (boolean)true)) {
            String current;
            int i = 0;
            while ((current = jEdit.getProperty((String)("xinsert.inserts." + i))) != null) {
                this.loadInternalInsert(current);
                ++i;
            }
        }
        if (jEdit.getBooleanProperty((String)"xinsert.display.macros", (boolean)true)) {
            this.addMenu("Macros");
            Vector vec = Macros.getMacroHierarchy();
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof Vector) {
                    this.loadMacroVector((Vector)o);
                    continue;
                }
                if (o instanceof String) {
                    this.loadNamedMacro(Macros.getMacro((String)((String)o)));
                    continue;
                }
                this.loadNamedMacro((Macros.Macro)o);
            }
            this.closeMenu();
        }
        this.build();
        this.tree.expandRow(0);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
    }

    private void loadMacroVector(Vector v) {
        Iterator iter = v.iterator();
        this.addMenu(iter.next().toString());
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof Vector) {
                this.loadMacroVector((Vector)o);
                continue;
            }
            this.loadNamedMacro(Macros.getMacro((String)o.toString()));
        }
        this.closeMenu();
    }

    private void loadNamedMacro(Macros.Macro macro) {
        this.addInsert(macro.getLabel(), macro.getName(), 3);
    }

    private void loadInternalInsert(String fileName) {
        try {
            if (jEdit.getBooleanProperty((String)("xinsert.display." + fileName), (boolean)true)) {
                if (!XInsertReader.read(this, (class$XTree == null ? (class$XTree = XTree.class$("XTree")) : class$XTree).getResourceAsStream(fileName + ".insert.xml"), fileName + ".xinsert.xml")) {
                    Log.log((int)9, (Object)this, (Object)("Resource not found: " + fileName));
                } else {
                    Log.log((int)5, (Object)this, (Object)("Resource loaded: " + fileName));
                }
            }
        }
        catch (NullPointerException e) {
            Log.log((int)9, (Object)this, (Object)("Resource not found: " + fileName));
        }
    }

    private void reload() {
        this.root.removeAllChildren();
        this.init();
        this.treeModel.reload();
        this.tree.repaint();
    }

    private void build() {
        String[] inserts;
        File f;
        String dir = jEdit.getProperty((String)"xinsert.inserts-directory");
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        if (!(f = new File(dir)).exists()) {
            f.mkdirs();
        }
        if ((inserts = Utilities.getWildCardMatches(dir, "*.insert.xml", false)) == null) {
            return;
        }
        try {
            for (int i = 0; i < inserts.length; ++i) {
                String fileName = dir + inserts[i];
                if (!XInsertReader.read(this, new FileInputStream(fileName), fileName)) continue;
                Object[] args = new String[]{inserts[i]};
                System.out.println(jEdit.getProperty((String)"xtree.loaded", (Object[])args));
            }
        }
        catch (FileNotFoundException fnfe) {
            // empty catch block
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        JTree source = (JTree)e.getSource();
        if (source.isSelectionEmpty()) {
            return;
        }
        XTreeNode node = (XTreeNode)source.getSelectionPath().getLastPathComponent();
        if (node.getIndex() != -1) {
            this.insert(node);
        }
        this.parent.getTextArea().requestFocus();
        this.parent.toFront();
        source.clearSelection();
    }

    public void reload(DefaultTreeModel model) {
        this.tree.setModel(model);
    }

    public void actionPerformed(ActionEvent evt) {
        Object o = evt.getSource();
        if (o == this.expand) {
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                this.tree.expandRow(i);
            }
        } else if (o == this.collapse) {
            for (int i = this.tree.getRowCount(); i >= 0; --i) {
                this.tree.collapseRow(i);
            }
        } else if (o == this.reload) {
            this.reload();
        } else if (o == this.carriageReturn) {
            jEdit.setBooleanProperty((String)"xtree.carriage", (boolean)this.carriageReturn.isSelected());
        } else if (o == this.executeScript) {
            jEdit.setBooleanProperty((String)"xtree.execute", (boolean)this.executeScript.isSelected());
        }
    }

    private void insert(XTreeNode node) {
        if (!this.parent.getTextArea().isEditable()) {
            this.parent.getToolkit().beep();
            return;
        }
        XTreeItem item = (XTreeItem)inserts.elementAt(node.getIndex() - 1);
        String data = item.getContent();
        int type = item.getType();
        if (type == 0 || !this.executeScript.isSelected()) {
            this.insertText(node, false);
        } else {
            if (type == 1) {
                Log.log((int)1, (Object)this, (Object)"Running Macro...");
                XScripter.runMacro(this.parent, (String)node.getUserObject(), data);
                return;
            }
            if (type == 2) {
                Log.log((int)1, (Object)this, (Object)"Running XInsert Script ...");
                XScripter.runXInsertScript(this.parent, data, node);
            } else {
                if (type == 3) {
                    Log.log((int)1, (Object)this, (Object)"Running Named Macro...");
                    XScripter.runNamedMacro(this.parent, (String)node.getUserObject(), data);
                    return;
                }
                this.insertText(node, true);
            }
        }
    }

    public void insertText(XTreeNode node, boolean error) {
        String data = ((XTreeItem)inserts.elementAt(node.getIndex() - 1)).getContent();
        JEditTextArea textArea = this.parent.getTextArea();
        Buffer buffer = this.parent.getBuffer();
        buffer.beginCompoundEdit();
        String selected = textArea.getSelectedText() != null ? textArea.getSelectedText() : "";
        int j = 0;
        int pos = -1;
        char c = '\u0000';
        this.lineNo = 0;
        StringBuffer buf = new StringBuffer(data.length());
        for (int i = 0; i < data.length(); ++i) {
            c = data.charAt(i);
            switch (c) {
                case '|': {
                    if (i < data.length() - 1 && data.charAt(i + 1) == '|') {
                        ++i;
                        buf.append(c);
                        break;
                    }
                    buf.append(selected);
                    pos = j;
                    break;
                }
                case '\\': {
                    if (i < data.length() - 1 && data.charAt(i + 1) == 'n') {
                        ++i;
                        ++this.lineNo;
                        buf.append('\n');
                        break;
                    }
                    if (i < data.length() - 1 && data.charAt(i + 1) == 't') {
                        ++i;
                        int tabSize = buffer.getTabSize();
                        if (jEdit.getBooleanProperty((String)"buffer.noTabs", (boolean)false)) {
                            for (int k = 0; k < tabSize; ++k) {
                                buf.append(" ");
                            }
                            break;
                        }
                        buf.append("\t");
                        break;
                    }
                    if (i < data.length() - 1 && data.charAt(i + 1) == '$') {
                        ++i;
                        buf.append('$');
                        break;
                    }
                    if (i < data.length() - 1 && data.charAt(i + 1) == '\\') {
                        ++i;
                        buf.append(c);
                        break;
                    }
                    buf.append(c);
                    break;
                }
                case '\n': {
                    ++this.lineNo;
                    buf.append(c);
                    break;
                }
                case '$': {
                    int tempi = ++i;
                    while (i < data.length() && Character.isLetterOrDigit(data.charAt(i))) {
                        ++i;
                    }
                    Log.log((int)1, (Object)this, (Object)("$ = " + data.substring(tempi, i)));
                    String val = XScripter.getSubstituteFor(this.parent, data.substring(tempi, i), node);
                    if (val == null) {
                        buf.append(data.substring(tempi, i));
                    } else {
                        buf.append(val);
                    }
                    --i;
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++j;
        }
        int tmp = textArea.getCaretPosition();
        if (this.carriageReturn.isSelected()) {
            buf.append('\n');
        }
        if (error) {
            buf.insert(0, "\nERROR: UNKNOWN INSERT TYPE\n");
        }
        textArea.setSelectedText(buf.toString());
        if (pos != -1) {
            textArea.setCaretPosition(tmp + pos);
        }
        buffer.endCompoundEdit();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        plainLeaf = Utilities.getIcon("images/tree_leaf.gif");
        scriptLeaf = Utilities.getIcon("images/tree_leaf_script_x.gif");
        macroLeaf = Utilities.getIcon("images/tree_leaf_macro.gif");
        namedmacroLeaf = Utilities.getIcon("images/tree_leaf_namedmacro.gif");
        errorLeaf = Utilities.getIcon("images/tree_leaf_error.gif");
    }

    private class XTreeTree
    extends JTree {
        public XTreeTree(TreeModel model) {
            super(model);
        }

        public String getToolTipText(MouseEvent e) {
            if (e == null) {
                return null;
            }
            TreePath tPath = XTree.this.tree.getPathForLocation(e.getX(), e.getY());
            if (tPath != null) {
                XTreeNode node = (XTreeNode)tPath.getLastPathComponent();
                if (!node.isLeaf()) {
                    return null;
                }
                try {
                    XTreeItem item = (XTreeItem)inserts.elementAt(node.getIndex() - 1);
                    int type = item.getType();
                    String content = item.getContent();
                    if (type == 0) {
                        return content;
                    }
                    if (type == 1) {
                        return "Macro";
                    }
                    if (type == 2) {
                        return "Script";
                    }
                    if (type == 3) {
                        return "Named Macro";
                    }
                    return "Error: " + content;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    return null;
                }
            }
            return null;
        }
    }

    class XTreeCellRenderer
    extends DefaultTreeCellRenderer {
        XTreeCellRenderer() {
            this.textSelectionColor = Color.red;
            this.borderSelectionColor = XTree.this.tree.getBackground();
            this.backgroundSelectionColor = XTree.this.tree.getBackground();
        }

        public Component getTreeCellRendererComponent(JTree source, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            XTreeNode node;
            int index;
            TreePath path;
            if (leaf && (path = source.getPathForRow(row)) != null && (index = (node = (XTreeNode)path.getLastPathComponent()).getIndex()) != -1) {
                int type = ((XTreeItem)inserts.elementAt(index - 1)).getType();
                switch (type) {
                    case 0: {
                        this.leafIcon = plainLeaf;
                        break;
                    }
                    case 2: {
                        this.leafIcon = scriptLeaf;
                        break;
                    }
                    case 1: {
                        this.leafIcon = macroLeaf;
                        break;
                    }
                    case 3: {
                        this.leafIcon = namedmacroLeaf;
                        break;
                    }
                    default: {
                        this.leafIcon = errorLeaf;
                    }
                }
            }
            return super.getTreeCellRendererComponent(source, value, sel, expanded, leaf, row, hasFocus);
        }
    }
}

